/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.introspection;

import java.net.URI;
import java.util.HashSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.binding.jms.model.ActivationSpec;
import org.fabric3.api.binding.jms.model.CacheLevel;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.CorrelationScheme;
import org.fabric3.api.binding.jms.model.CreateOption;
import org.fabric3.api.binding.jms.model.DeliveryMode;
import org.fabric3.api.binding.jms.model.DestinationDefinition;
import org.fabric3.api.binding.jms.model.DestinationType;
import org.fabric3.api.binding.jms.model.HeadersDefinition;
import org.fabric3.api.binding.jms.model.JmsBindingDefinition;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.api.binding.jms.model.MessageSelection;
import org.fabric3.api.binding.jms.model.OperationPropertiesDefinition;
import org.fabric3.api.binding.jms.model.PropertyAwareObject;
import org.fabric3.api.binding.jms.model.ResponseDefinition;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.component.BindingHandlerDefinition;
import org.fabric3.binding.jms.introspection.InvalidJmsBinding;
import org.fabric3.binding.jms.introspection.JmsLoaderHelper;
import org.fabric3.binding.jms.introspection.JmsUriException;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JmsBindingLoader
extends AbstractValidatingTypeLoader<JmsBindingDefinition> {
    private LoaderRegistry registry;
    private LoaderHelper loaderHelper;
    private int defaultResponseTimeout = 600000;
    private int defaultTransactionTimeout = 30;
    private int defaultReceiveTimeout = this.defaultTransactionTimeout / 2 * 1000;

    @Property(required=false)
    @Source(value="$systemConfig//f3:jms/@response.timeout")
    public void setDefaultResponseTimeout(int defaultResponseTimeout) {
        this.defaultResponseTimeout = defaultResponseTimeout;
    }

    @Property(required=false)
    @Source(value="$systemConfig//f3:jms/@transaction.timeout")
    public void setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        this.defaultTransactionTimeout = defaultTransactionTimeout;
        this.defaultReceiveTimeout = defaultTransactionTimeout / 2 * 1000;
    }

    public JmsBindingLoader(@Reference LoaderHelper loaderHelper, @Reference LoaderRegistry registry) {
        this.loaderHelper = loaderHelper;
        this.registry = registry;
        this.addAttributes(new String[]{"uri", "activationSpec", "wireFormat", "jndiURL", "initialContextFactory", "requires", "messageSelection", "policySets", "create", "type", "destination", "connectionFactory", "messageSelection", "type", "timeToLive", "resourceAdapter", "priority", "deliveryMode", "correlationScheme", "name", "cache", "idle.limit", "receive.timeout", "response.timeout", "max.messages", "recovery.interval", "max.receivers", "min.receivers"});
    }

    public JmsBindingDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        JmsBindingMetadata metadata;
        Location startLocation = reader.getLocation();
        String bindingName = reader.getAttributeValue(null, "name");
        String uri = reader.getAttributeValue(null, "uri");
        if (uri != null) {
            try {
                metadata = JmsLoaderHelper.parseUri(uri);
            }
            catch (JmsUriException e) {
                InvalidValue failure = new InvalidValue("Invalid JMS binding URI: " + uri, startLocation, (Throwable)((Object)e), new ModelObject[0]);
                context.addError((ValidationFailure)failure);
                return null;
            }
        } else {
            metadata = new JmsBindingMetadata();
        }
        JmsBindingDefinition definition = new JmsBindingDefinition(bindingName, metadata);
        NamespaceContext namespace = reader.getNamespaceContext();
        String targetNamespace = context.getTargetNamespace();
        this.parseCorrelationScheme(metadata, namespace, targetNamespace, reader, context);
        metadata.setJndiUrl(reader.getAttributeValue(null, "jndiURL"));
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)definition, reader, context);
        this.loadFabric3Attributes(metadata, reader, context);
        this.validateAttributes(reader, context, new ModelObject[]{definition});
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String name = reader.getName().getLocalPart();
                    Location location = reader.getLocation();
                    if ("handler".equals(name)) {
                        BindingHandlerDefinition handler = (BindingHandlerDefinition)this.registry.load(reader, BindingHandlerDefinition.class, context);
                        definition.addHandler(handler);
                        break;
                    }
                    if ("destination".equals(name)) {
                        if (uri != null) {
                            InvalidJmsBinding error = new InvalidJmsBinding("A destination cannot be defined both as a JMS uri and as part of the binding.jms element", location, (ModelObject)definition);
                            context.addError((ValidationFailure)error);
                        }
                        DestinationDefinition destination = this.loadDestination(reader, context);
                        metadata.setDestination(destination);
                        break;
                    }
                    if ("connectionFactory".equals(name)) {
                        ConnectionFactoryDefinition connectionFactory = this.loadConnectionFactory(reader, context);
                        metadata.setConnectionFactory(connectionFactory);
                        break;
                    }
                    if ("activationSpec".equals(name)) {
                        ActivationSpec spec = this.loadActivationSpec(reader, context);
                        metadata.setActivationSpec(spec);
                        break;
                    }
                    if ("response".equals(name)) {
                        ResponseDefinition response = this.loadResponse(reader, context);
                        metadata.setResponse(response);
                        break;
                    }
                    if ("headers".equals(name)) {
                        HeadersDefinition headers = metadata.getHeaders();
                        this.loadHeaders(headers, reader, context);
                        break;
                    }
                    if ("messageSelection".equals(name)) {
                        MessageSelection messageSelection = this.loadMessageSelection(reader, context);
                        metadata.setMessageSelection(messageSelection);
                        break;
                    }
                    if (!"operationProperties".equals(name)) break;
                    OperationPropertiesDefinition operationProperties = this.loadOperationProperties(reader, context);
                    metadata.addOperationProperties(operationProperties.getName(), operationProperties);
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!"binding.jms".equals(name)) break;
                    DestinationDefinition destinationDefinition = metadata.getDestination();
                    if (destinationDefinition != null) {
                        String target = destinationDefinition.getName();
                        URI bindingUri = URI.create("jms://" + target);
                        definition.setGeneratedTargetUri(bindingUri);
                    } else if (metadata.getActivationSpec() != null) {
                        String target = metadata.getActivationSpec().getName();
                        URI bindingUri = URI.create("jms://" + target);
                        definition.setGeneratedTargetUri(bindingUri);
                    }
                    this.validate(definition, reader, context);
                    return definition;
                }
            }
        }
    }

    private void parseCorrelationScheme(JmsBindingMetadata metadata, NamespaceContext namespace, String targetNamespace, XMLStreamReader reader, IntrospectionContext context) {
        Location startLocation = reader.getLocation();
        String correlationScheme = reader.getAttributeValue(null, "correlationScheme");
        if (correlationScheme != null) {
            QName scheme = LoaderUtil.getQName((String)correlationScheme, (String)targetNamespace, (NamespaceContext)namespace);
            String localPart = scheme.getLocalPart();
            if ("messageID".equalsIgnoreCase(localPart)) {
                metadata.setCorrelationScheme(CorrelationScheme.MESSAGE_ID);
            } else if ("correlationID".equalsIgnoreCase(localPart)) {
                metadata.setCorrelationScheme(CorrelationScheme.CORRELATION_ID);
            } else if ("none".equalsIgnoreCase(localPart)) {
                metadata.setCorrelationScheme(CorrelationScheme.NONE);
            } else {
                InvalidValue error = new InvalidValue("Invalid value specified for correlationScheme attribute: " + localPart, startLocation, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
    }

    private void loadFabric3Attributes(JmsBindingMetadata metadata, XMLStreamReader reader, IntrospectionContext context) {
        String min;
        String max;
        String recoveryInterval;
        Location startLocation = reader.getLocation();
        String cacheLevel = reader.getAttributeValue(null, "cache");
        if ("connection".equalsIgnoreCase(cacheLevel)) {
            metadata.setCacheLevel(CacheLevel.CONNECTION);
        } else if ("session".equalsIgnoreCase(cacheLevel)) {
            metadata.setCacheLevel(CacheLevel.ADMINISTERED_OBJECTS);
        } else if (cacheLevel != null) {
            InvalidValue error = new InvalidValue("Invalid cache level attribute", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)error);
        }
        String idleLimit = reader.getAttributeValue(null, "idle.limit");
        if (idleLimit != null) {
            try {
                int val = Integer.parseInt(idleLimit);
                metadata.setIdleLimit(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid idle.limit attribute", startLocation, (Throwable)e, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        String receiveTimeout = reader.getAttributeValue(null, "receive.timeout");
        int receiveVal = this.defaultReceiveTimeout;
        if (receiveTimeout != null) {
            try {
                receiveVal = Integer.parseInt(receiveTimeout);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid receive.timeout attribute", startLocation, (Throwable)e, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        metadata.setReceiveTimeout(receiveVal);
        String responseTimeout = reader.getAttributeValue(null, "response.timeout");
        int responseVal = this.defaultResponseTimeout;
        if (responseTimeout != null) {
            try {
                responseVal = Integer.parseInt(responseTimeout);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid response.timeout attribute", startLocation, (Throwable)e, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        metadata.setResponseTimeout(responseVal);
        String maxMessagesProcess = reader.getAttributeValue(null, "max.messages");
        if (maxMessagesProcess != null) {
            try {
                int val = Integer.parseInt(maxMessagesProcess);
                metadata.setMaxMessagesToProcess(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid max.messages attribute", startLocation, (Throwable)e, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        if ((recoveryInterval = reader.getAttributeValue(null, "recovery.interval")) != null) {
            try {
                int val = Integer.parseInt(recoveryInterval);
                metadata.setRecoveryInterval((long)val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid recovery.interval attribute", startLocation, (Throwable)e, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        if ((max = reader.getAttributeValue(null, "max.receivers")) != null) {
            try {
                int val = Integer.parseInt(max);
                metadata.setMaxReceivers(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid max.receivers attribute", startLocation, (Throwable)e, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        if ((min = reader.getAttributeValue(null, "min.receivers")) != null) {
            try {
                int val = Integer.parseInt(min);
                metadata.setMinReceivers(val);
            }
            catch (NumberFormatException e) {
                InvalidValue error = new InvalidValue("Invalid min.receivers attribute", startLocation, (Throwable)e, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
    }

    private ActivationSpec loadActivationSpec(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        String jndiName = reader.getAttributeValue(null, "jndiName");
        CreateOption create = this.parseCreate(reader, context);
        ActivationSpec spec = new ActivationSpec(jndiName, create);
        this.loadProperties(reader, (PropertyAwareObject)spec, "activationSpec");
        return spec;
    }

    private ResponseDefinition loadResponse(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ResponseDefinition response = new ResponseDefinition();
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String name = reader.getName().getLocalPart();
                    if ("destination".equals(name)) {
                        DestinationDefinition destination = this.loadDestination(reader, context);
                        response.setDestination(destination);
                        break;
                    }
                    if ("activationSpec".equals(name)) {
                        ActivationSpec spec = this.loadActivationSpec(reader, context);
                        response.setActivationSpec(spec);
                        break;
                    }
                    if (!"connectionFactory".equals(name)) break;
                    ConnectionFactoryDefinition connectionFactory = this.loadConnectionFactory(reader, context);
                    response.setConnectionFactory(connectionFactory);
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!"response".equals(name)) break;
                    return response;
                }
            }
        }
    }

    private ConnectionFactoryDefinition loadConnectionFactory(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ConnectionFactoryDefinition connectionFactory = new ConnectionFactoryDefinition();
        connectionFactory.setName(reader.getAttributeValue(null, "jndiName"));
        CreateOption create = this.parseCreate(reader, context);
        connectionFactory.setCreate(create);
        this.loadProperties(reader, (PropertyAwareObject)connectionFactory, "connectionFactory");
        return connectionFactory;
    }

    private DestinationDefinition loadDestination(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location location = reader.getLocation();
        DestinationDefinition destination = new DestinationDefinition();
        String jndiName = reader.getAttributeValue(null, "jndiName");
        if (jndiName != null) {
            destination.setName(jndiName);
        } else {
            String name = reader.getAttributeValue(null, "name");
            if (name == null) {
                MissingAttribute error = new MissingAttribute("Destination must have either a jndiName or name attribute set", location, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        CreateOption create = this.parseCreate(reader, context);
        destination.setCreate(create);
        String type = reader.getAttributeValue(null, "type");
        if (type != null) {
            if ("queue".equalsIgnoreCase(type)) {
                destination.setType(DestinationType.QUEUE);
            } else if ("topic".equalsIgnoreCase(type)) {
                destination.setType(DestinationType.TOPIC);
            } else {
                InvalidValue error = new InvalidValue("Invalid value specified for destination type: " + type, location, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        this.loadProperties(reader, (PropertyAwareObject)destination, "destination");
        return destination;
    }

    private CreateOption parseCreate(XMLStreamReader reader, IntrospectionContext context) {
        Location startLocation = reader.getLocation();
        String create = reader.getAttributeValue(null, "create");
        if (create != null) {
            if ("always".equals(create)) {
                return CreateOption.ALWAYS;
            }
            if ("never".equalsIgnoreCase(create)) {
                return CreateOption.NEVER;
            }
            if ("ifNotExist".equalsIgnoreCase(create)) {
                return CreateOption.IF_NOT_EXIST;
            }
            InvalidValue error = new InvalidValue("Invalid value specified for create attribute: " + create, startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)error);
        }
        return CreateOption.IF_NOT_EXIST;
    }

    private void loadHeaders(HeadersDefinition headers, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        String timeToLive;
        String priority;
        Location startLocation = reader.getLocation();
        String deliveryMode = reader.getAttributeValue(null, "deliveryMode");
        if (deliveryMode != null) {
            if ("PERSISTENT".equalsIgnoreCase(deliveryMode)) {
                headers.setDeliveryMode(DeliveryMode.PERSISTENT);
            } else if ("NONPERSISTENT".equalsIgnoreCase(deliveryMode)) {
                headers.setDeliveryMode(DeliveryMode.NON_PERSISTENT);
            } else {
                InvalidValue failure = new InvalidValue("Invalid delivery mode: " + deliveryMode, startLocation, new ModelObject[0]);
                context.addError((ValidationFailure)failure);
            }
        }
        if ((priority = reader.getAttributeValue(null, "priority")) != null) {
            InvalidValue failure;
            try {
                Integer value = Integer.valueOf(priority);
                headers.setPriority(value.intValue());
                if (value < 0 || value > 9) {
                    failure = new InvalidValue("Invalid priority: " + priority + ". Values must be from 0-9.", startLocation, new ModelObject[0]);
                    context.addError((ValidationFailure)failure);
                }
            }
            catch (NumberFormatException nfe) {
                failure = new InvalidValue("Invalid priority: " + priority, startLocation, (Throwable)nfe, new ModelObject[0]);
                context.addError((ValidationFailure)failure);
            }
        }
        if ((timeToLive = reader.getAttributeValue(null, "timeToLive")) != null) {
            try {
                headers.setTimeToLive(Long.valueOf(timeToLive).longValue());
            }
            catch (NumberFormatException nfe) {
                InvalidValue failure = new InvalidValue("Invalid time-to-live value: " + timeToLive, startLocation, (Throwable)nfe, new ModelObject[0]);
                context.addError((ValidationFailure)failure);
            }
        }
        headers.setJmsType(reader.getAttributeValue(null, "type"));
        this.loadProperties(reader, (PropertyAwareObject)headers, "headers");
    }

    private MessageSelection loadMessageSelection(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location location = reader.getLocation();
        String selector = reader.getAttributeValue(null, "selector");
        if (selector == null) {
            MissingAttribute error = new MissingAttribute("Selector not specified for message selection", location, new ModelObject[0]);
            context.addError((ValidationFailure)error);
            selector = "invalid";
        }
        MessageSelection messageSelection = new MessageSelection(selector);
        this.loadProperties(reader, (PropertyAwareObject)messageSelection, "messageSelection");
        return messageSelection;
    }

    private OperationPropertiesDefinition loadOperationProperties(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        OperationPropertiesDefinition operationProperties = new OperationPropertiesDefinition();
        operationProperties.setName(reader.getAttributeValue(null, "name"));
        operationProperties.setSelectedOperation(reader.getAttributeValue(null, "selectedOperation"));
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String name = reader.getName().getLocalPart();
                    if ("headers".equals(name)) {
                        HeadersDefinition headers = operationProperties.getHeaders();
                        this.loadHeaders(headers, reader, context);
                        break;
                    }
                    if (!"property".equals(name)) break;
                    this.loadProperty(reader, (PropertyAwareObject)operationProperties);
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!"operationProperties".equals(name)) break;
                    return operationProperties;
                }
            }
        }
    }

    private void loadProperties(XMLStreamReader reader, PropertyAwareObject parent, String parentName) throws XMLStreamException {
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String name = reader.getName().getLocalPart();
                    if (!"property".equals(name)) break;
                    this.loadProperty(reader, parent);
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!parentName.equals(name)) break;
                    return;
                }
            }
        }
    }

    private void loadProperty(XMLStreamReader reader, PropertyAwareObject parent) throws XMLStreamException {
        String key = reader.getAttributeValue(null, "name");
        String value = reader.getElementText();
        parent.addProperty(key, value);
    }

    private void validate(JmsBindingDefinition definition, XMLStreamReader reader, IntrospectionContext context) {
        ResponseDefinition response;
        InvalidJmsBinding error;
        Location location;
        JmsBindingMetadata metadata = definition.getJmsMetadata();
        if (metadata.getConnectionFactory().isConfigured() && metadata.getDestination() == null) {
            location = reader.getLocation();
            error = new InvalidJmsBinding("A destination must be specified", location, (ModelObject)definition);
            context.addError((ValidationFailure)error);
        }
        if (metadata.getActivationSpec() != null && metadata.getConnectionFactory().isConfigured()) {
            location = reader.getLocation();
            error = new InvalidJmsBinding("Activation spec and connection factory cannot both be specified on a JMS binding", location, (ModelObject)definition);
            context.addError((ValidationFailure)error);
        }
        DestinationDefinition requestDestination = metadata.getDestination();
        ActivationSpec requestSpec = metadata.getActivationSpec();
        if (requestDestination != null && requestSpec != null && requestDestination.getName() != null && !requestDestination.getName().equals(requestSpec.getName())) {
            Location location2 = reader.getLocation();
            InvalidJmsBinding error2 = new InvalidJmsBinding("Activation spec and destination configuration must refer to the same destination", location2, (ModelObject)definition);
            context.addError((ValidationFailure)error2);
        }
        if ((response = metadata.getResponse()) != null) {
            DestinationDefinition responseDestination;
            ActivationSpec responseSpec = response.getActivationSpec();
            if (responseSpec != null && response.getConnectionFactory().isConfigured()) {
                Location location3 = reader.getLocation();
                InvalidJmsBinding error3 = new InvalidJmsBinding("Activation spec and connection factory cannot both be specified on a JMS binding", location3, (ModelObject)definition);
                context.addError((ValidationFailure)error3);
            }
            if ((responseDestination = response.getDestination()) != null && responseSpec != null && responseDestination.getName() != null && !responseDestination.getName().equals(responseSpec.getName())) {
                Location location4 = reader.getLocation();
                InvalidJmsBinding error4 = new InvalidJmsBinding("Activation spec and destination configuration must refer to the same destination", location4, (ModelObject)definition);
                context.addError((ValidationFailure)error4);
            }
        }
        HashSet<String> seen = new HashSet<String>();
        for (OperationPropertiesDefinition entry : metadata.getOperationProperties().values()) {
            String name = entry.getSelectedOperation();
            if (seen.contains(name)) {
                Location location5 = reader.getLocation();
                InvalidJmsBinding error5 = new InvalidJmsBinding("Duplicate selected operation for property defined: " + name, location5, (ModelObject)definition);
                context.addError((ValidationFailure)error5);
                continue;
            }
            seen.add(name);
        }
    }
}

