/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.api.binding.jms.model.ActivationSpec;
import org.fabric3.api.binding.jms.model.CreateOption;
import org.fabric3.api.binding.jms.model.DeliveryMode;
import org.fabric3.api.binding.jms.model.DestinationDefinition;
import org.fabric3.api.binding.jms.model.JmsBindingDefinition;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.api.binding.jms.model.ResponseDefinition;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.definitions.Intent;
import org.fabric3.binding.jms.generator.JmsGenerationException;
import org.fabric3.binding.jms.generator.JmsGeneratorHelper;
import org.fabric3.binding.jms.generator.PayloadTypeIntrospector;
import org.fabric3.binding.jms.spi.generator.JmsResourceProvisioner;
import org.fabric3.binding.jms.spi.provision.JmsWireSourceDefinition;
import org.fabric3.binding.jms.spi.provision.JmsWireTargetDefinition;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.provision.SessionType;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.policy.EffectivePolicy;
import org.fabric3.spi.domain.generator.wire.WireBindingGenerator;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.physical.PhysicalBindingHandlerDefinition;
import org.fabric3.spi.model.physical.PhysicalDataTypes;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JmsWireBindingGenerator
implements WireBindingGenerator<JmsBindingDefinition> {
    private static final String JAXB = "JAXB";
    private static final QName TRANSACTED_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "transactedOneWay");
    private static final QName IMMEDIATE_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "immediateOneWay");
    private static final QName ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "oneWay");
    private static final QName NON_PERSISTENT = new QName("urn:fabric3.org", "nonPersistent");
    private PayloadTypeIntrospector introspector;
    private HostInfo info;
    private JmsResourceProvisioner provisioner;

    public JmsWireBindingGenerator(@Reference PayloadTypeIntrospector introspector, @Reference HostInfo info) {
        this.introspector = introspector;
        this.info = info;
    }

    @Reference(required=false)
    public void setProvisioner(JmsResourceProvisioner provisioner) {
        this.provisioner = provisioner;
    }

    public JmsWireSourceDefinition generateSource(LogicalBinding<JmsBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        SessionType sessionType = this.getSessionType(operations, policy);
        JmsBindingMetadata metadata = ((JmsBindingDefinition)binding.getDefinition()).getJmsMetadata().snapshot();
        JmsGeneratorHelper.generateDefaultFactoryConfiguration(metadata.getConnectionFactory(), sessionType);
        if (metadata.getResponseConnectionFactory() != null) {
            JmsGeneratorHelper.generateDefaultFactoryConfiguration(metadata.getResponseConnectionFactory(), sessionType);
        }
        this.processServiceResponse(metadata, contract);
        this.generateIntents(binding, metadata);
        List<OperationPayloadTypes> payloadTypes = this.processPayloadTypes(contract);
        URI uri = ((JmsBindingDefinition)binding.getDefinition()).getTargetUri();
        List<PhysicalBindingHandlerDefinition> handlers = JmsGeneratorHelper.generateBindingHandlers(this.info.getDomain(), (JmsBindingDefinition)binding.getDefinition());
        JmsWireSourceDefinition definition = this.isJAXB(contract) ? new JmsWireSourceDefinition(uri, metadata, payloadTypes, sessionType, handlers, PhysicalDataTypes.JAXB) : new JmsWireSourceDefinition(uri, metadata, payloadTypes, sessionType, handlers);
        if (this.provisioner != null) {
            this.provisioner.generateSource(definition);
        }
        this.processDestinationDefinitions(metadata, false);
        return definition;
    }

    public JmsWireTargetDefinition generateTarget(LogicalBinding<JmsBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        SessionType sessionType = this.getSessionType(operations, policy);
        URI uri = ((JmsBindingDefinition)binding.getDefinition()).getTargetUri();
        JmsBindingMetadata metadata = ((JmsBindingDefinition)binding.getDefinition()).getJmsMetadata().snapshot();
        JmsGeneratorHelper.generateDefaultFactoryConfiguration(metadata.getConnectionFactory(), sessionType);
        if (metadata.getResponseConnectionFactory() != null) {
            JmsGeneratorHelper.generateDefaultFactoryConfiguration(metadata.getResponseConnectionFactory(), sessionType);
        }
        this.processReferenceResponse(metadata, contract);
        List<OperationPayloadTypes> payloadTypes = this.processPayloadTypes(contract);
        List<PhysicalBindingHandlerDefinition> handlers = JmsGeneratorHelper.generateBindingHandlers(this.info.getDomain(), (JmsBindingDefinition)binding.getDefinition());
        JmsWireTargetDefinition definition = this.isJAXB(contract) ? new JmsWireTargetDefinition(uri, metadata, payloadTypes, sessionType, handlers, PhysicalDataTypes.JAXB) : new JmsWireTargetDefinition(uri, metadata, payloadTypes, sessionType, handlers);
        if (this.provisioner != null) {
            this.provisioner.generateTarget(definition);
        }
        this.processDestinationDefinitions(metadata, true);
        if (contract.getCallbackContract() != null) {
            for (LogicalBinding callbackBinding : ((Bindable)binding.getParent()).getCallbackBindings()) {
                if (!(callbackBinding.getDefinition() instanceof JmsBindingDefinition)) continue;
                JmsBindingDefinition callbackDefinition = (JmsBindingDefinition)callbackBinding.getDefinition();
                DestinationDefinition callbackDestination = callbackDefinition.getJmsMetadata().getDestination();
                definition.setCallbackDestination(callbackDestination);
            }
        }
        return definition;
    }

    public JmsWireTargetDefinition generateServiceBindingTarget(LogicalBinding<JmsBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        return this.generateTarget((LogicalBinding)binding, contract, (List)operations, policy);
    }

    private boolean isJAXB(ServiceContract contract) {
        for (Operation operation : contract.getOperations()) {
            if (operation.getInputTypes().isEmpty() || !JAXB.equals(((DataType)operation.getInputTypes().get(0)).getDatabinding())) continue;
            return true;
        }
        return false;
    }

    private void processReferenceResponse(JmsBindingMetadata metadata, ServiceContract contract) {
        if (metadata.isResponse()) {
            return;
        }
        for (Operation operation : contract.getOperations()) {
            if (operation.getIntents().contains(ONEWAY)) continue;
            ResponseDefinition responseDefinition = new ResponseDefinition();
            responseDefinition.setConnectionFactory(metadata.getConnectionFactory());
            DestinationDefinition destinationDefinition = new DestinationDefinition();
            destinationDefinition.setCreate(CreateOption.IF_NOT_EXIST);
            destinationDefinition.setName(metadata.getDestination().getName() + "Response");
            responseDefinition.setDestination(destinationDefinition);
            metadata.setResponse(responseDefinition);
            break;
        }
    }

    private void processServiceResponse(JmsBindingMetadata metadata, ServiceContract contract) throws JmsGenerationException {
        if (metadata.isResponse()) {
            if (metadata.getResponse().getActivationSpec() != null) {
                throw new JmsGenerationException("Activation spec not allowed on a service binding response");
            }
            return;
        }
        for (Operation operation : contract.getOperations()) {
            if (operation.getIntents().contains(ONEWAY)) continue;
            ResponseDefinition responseDefinition = new ResponseDefinition();
            responseDefinition.setConnectionFactory(metadata.getConnectionFactory());
            metadata.setResponse(responseDefinition);
            break;
        }
    }

    private void generateIntents(LogicalBinding<JmsBindingDefinition> binding, JmsBindingMetadata metadata) {
        Set intents = ((JmsBindingDefinition)binding.getDefinition()).getIntents();
        if (intents.contains(NON_PERSISTENT)) {
            metadata.getHeaders().setDeliveryMode(DeliveryMode.NON_PERSISTENT);
        }
    }

    private SessionType getSessionType(List<LogicalOperation> operations, EffectivePolicy policy) {
        for (LogicalOperation operation : operations) {
            for (Intent intent : policy.getIntents(operation)) {
                QName name = intent.getName();
                if (TRANSACTED_ONEWAY.equals(name)) {
                    return SessionType.GLOBAL_TRANSACTED;
                }
                if (!IMMEDIATE_ONEWAY.equals(name)) continue;
                return SessionType.AUTO_ACKNOWLEDGE;
            }
        }
        for (Intent intent : policy.getProvidedEndpointIntents()) {
            QName name = intent.getName();
            if (TRANSACTED_ONEWAY.equals(name)) {
                return SessionType.GLOBAL_TRANSACTED;
            }
            if (!IMMEDIATE_ONEWAY.equals(name)) continue;
            return SessionType.AUTO_ACKNOWLEDGE;
        }
        return SessionType.AUTO_ACKNOWLEDGE;
    }

    private List<OperationPayloadTypes> processPayloadTypes(ServiceContract serviceContract) throws JmsGenerationException {
        ArrayList<OperationPayloadTypes> types = new ArrayList<OperationPayloadTypes>();
        for (Operation operation : serviceContract.getOperations()) {
            OperationPayloadTypes payloadType = this.introspector.introspect(operation);
            types.add(payloadType);
        }
        return types;
    }

    private void processDestinationDefinitions(JmsBindingMetadata metadata, boolean reference) throws JmsGenerationException {
        ActivationSpec spec;
        DestinationDefinition destination = metadata.getDestination();
        if (destination == null && (spec = metadata.getActivationSpec()) != null) {
            if (reference) {
                throw new JmsGenerationException("Activation specification not allowed on a reference");
            }
            destination = this.populateActivationInformation(spec);
            metadata.setDestination(destination);
        }
        DestinationDefinition responseDestination = metadata.getResponseDestination();
        ResponseDefinition responseDefinition = metadata.getResponse();
        if (responseDestination == null && responseDefinition != null && responseDefinition.getActivationSpec() != null) {
            ActivationSpec spec2 = responseDefinition.getActivationSpec();
            responseDestination = this.populateActivationInformation(spec2);
            responseDefinition.setDestination(responseDestination);
        }
    }

    private DestinationDefinition populateActivationInformation(ActivationSpec spec) {
        DestinationDefinition destination = new DestinationDefinition();
        destination.setCreate(spec.getCreate());
        destination.setName(spec.getName());
        destination.addProperties(spec.getProperties());
        return destination;
    }
}

