/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.JmsBindingDefinition;
import org.fabric3.api.model.type.component.BindingHandlerDefinition;
import org.fabric3.binding.jms.spi.provision.SessionType;
import org.fabric3.spi.model.physical.PhysicalBindingHandlerDefinition;

public class JmsGeneratorHelper {
    public static String getSubscriptionId(URI uri) {
        String id = uri.getPath().substring(1).replace("/", ".");
        String fragment = uri.getFragment();
        if (fragment != null) {
            id = id + "." + fragment;
        }
        return id;
    }

    public static void generateDefaultFactoryConfiguration(ConnectionFactoryDefinition factory, SessionType sessionType) {
        if (factory.getName() == null && !factory.getProperties().containsKey("class")) {
            if (SessionType.GLOBAL_TRANSACTED == sessionType) {
                factory.setName("xaDefault");
            } else {
                factory.setName("default");
            }
        }
    }

    public static List<PhysicalBindingHandlerDefinition> generateBindingHandlers(URI domainUri, JmsBindingDefinition definition) {
        ArrayList<PhysicalBindingHandlerDefinition> handlers = new ArrayList<PhysicalBindingHandlerDefinition>();
        for (BindingHandlerDefinition handlerDefinition : definition.getHandlers()) {
            URI resolvedUri = URI.create(domainUri.toString() + "/" + handlerDefinition.getTarget());
            handlers.add(new PhysicalBindingHandlerDefinition(resolvedUri));
        }
        return handlers;
    }

    private JmsGeneratorHelper() {
    }
}

