/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.generator;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.binding.jms.model.DeliveryMode;
import org.fabric3.api.binding.jms.model.DestinationType;
import org.fabric3.api.binding.jms.model.JmsBindingDefinition;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.binding.jms.generator.JmsGeneratorHelper;
import org.fabric3.binding.jms.spi.generator.JmsResourceProvisioner;
import org.fabric3.binding.jms.spi.provision.JmsChannelBindingDefinition;
import org.fabric3.binding.jms.spi.provision.JmsConnectionSourceDefinition;
import org.fabric3.binding.jms.spi.provision.JmsConnectionTargetDefinition;
import org.fabric3.binding.jms.spi.provision.SessionType;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.channel.ConnectionBindingGenerator;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.physical.ChannelConstants;
import org.fabric3.spi.model.physical.ChannelDeliveryType;
import org.fabric3.spi.model.physical.PhysicalChannelBindingDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.fabric3.spi.model.physical.PhysicalDataTypes;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JmsConnectionBindingGenerator
implements ConnectionBindingGenerator<JmsBindingDefinition> {
    private static final String JAXB = "JAXB";
    private static final QName CLIENT_ACKNOWLEDGE_INTENT = new QName("urn:fabric3.org", "clientAcknowledge");
    private JmsResourceProvisioner provisioner;

    @Reference(required=false)
    public void setProvisioner(JmsResourceProvisioner provisioner) {
        this.provisioner = provisioner;
    }

    public PhysicalConnectionSourceDefinition generateConnectionSource(LogicalConsumer consumer, LogicalBinding<JmsBindingDefinition> binding, ChannelDeliveryType deliveryType) throws GenerationException {
        JmsBindingMetadata metadata = ((JmsBindingDefinition)binding.getDefinition()).getJmsMetadata().snapshot();
        this.generateIntents(binding, metadata);
        SessionType sessionType = this.getSessionType(binding);
        JmsGeneratorHelper.generateDefaultFactoryConfiguration(metadata.getConnectionFactory(), sessionType);
        URI uri = consumer.getUri();
        if (metadata.getSubscriptionId() == null && metadata.isDurable()) {
            metadata.setSubscriptionId(JmsGeneratorHelper.getSubscriptionId(uri));
        }
        String specifier = metadata.getSubscriptionId();
        metadata.setSubscriptionId(specifier);
        metadata.getDestination().setType(DestinationType.TOPIC);
        DataType dataType = this.isJAXB(consumer.getDefinition().getTypes()) ? PhysicalDataTypes.JAXB : PhysicalDataTypes.JAVA_TYPE;
        JmsConnectionSourceDefinition definition = new JmsConnectionSourceDefinition(uri, metadata, dataType, sessionType);
        if (this.provisioner != null) {
            this.provisioner.generateConnectionSource(definition);
        }
        return definition;
    }

    private SessionType getSessionType(LogicalBinding<JmsBindingDefinition> binding) {
        return ((JmsBindingDefinition)binding.getDefinition()).getIntents().contains(CLIENT_ACKNOWLEDGE_INTENT) ? SessionType.CLIENT_ACKNOWLEDGE : SessionType.AUTO_ACKNOWLEDGE;
    }

    public PhysicalConnectionTargetDefinition generateConnectionTarget(LogicalProducer producer, LogicalBinding<JmsBindingDefinition> binding, ChannelDeliveryType deliveryType) throws GenerationException {
        URI uri = ((JmsBindingDefinition)binding.getDefinition()).getTargetUri();
        JmsBindingMetadata metadata = ((JmsBindingDefinition)binding.getDefinition()).getJmsMetadata().snapshot();
        this.generateIntents(binding, metadata);
        JmsGeneratorHelper.generateDefaultFactoryConfiguration(metadata.getConnectionFactory(), SessionType.AUTO_ACKNOWLEDGE);
        DataType type = this.isJAXB(producer.getStreamOperation().getDefinition().getInputTypes()) ? PhysicalDataTypes.JAXB : PhysicalDataTypes.JAVA_TYPE;
        JmsConnectionTargetDefinition definition = new JmsConnectionTargetDefinition(uri, metadata, type);
        if (this.provisioner != null) {
            this.provisioner.generateConnectionTarget(definition);
        }
        return definition;
    }

    public PhysicalChannelBindingDefinition generateChannelBinding(LogicalBinding<JmsBindingDefinition> binding, ChannelDeliveryType deliveryType) throws GenerationException {
        return new JmsChannelBindingDefinition();
    }

    private void generateIntents(LogicalBinding<JmsBindingDefinition> binding, JmsBindingMetadata metadata) {
        LogicalChannel parent = (LogicalChannel)binding.getParent();
        if (((JmsBindingDefinition)binding.getDefinition()).getIntents().contains(ChannelConstants.DURABLE_INTENT) || parent.getDefinition().getIntents().contains(ChannelConstants.DURABLE_INTENT)) {
            metadata.setDurable(true);
        }
        if (((JmsBindingDefinition)binding.getDefinition()).getIntents().contains(ChannelConstants.NON_PERSISTENT_INTENT) || parent.getDefinition().getIntents().contains(ChannelConstants.NON_PERSISTENT_INTENT)) {
            metadata.getHeaders().setDeliveryMode(DeliveryMode.NON_PERSISTENT);
        }
    }

    private boolean isJAXB(List<DataType> eventTypes) {
        for (DataType eventType : eventTypes) {
            if (!JAXB.equals(eventType.getDatabinding())) continue;
            return true;
        }
        return false;
    }
}

