/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import com.sun.xml.wss.SecurityEnvironment;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.MetroWsdlWireTargetDefinition;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.provision.SecurityConfiguration;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.fabric3.binding.ws.metro.runtime.core.MetroDispatchObjectFactory;
import org.fabric3.binding.ws.metro.runtime.core.MetroDispatchTargetInterceptor;
import org.fabric3.binding.ws.metro.runtime.policy.FeatureResolver;
import org.fabric3.binding.ws.metro.runtime.wire.AbstractMetroTargetWireAttacher;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.binding.handler.BindingHandlerRegistry;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.fabric3.spi.repository.ArtifactCache;
import org.fabric3.spi.repository.CacheException;
import org.oasisopen.sca.annotation.Reference;

public class MetroWsdlTargetWireAttacher
extends AbstractMetroTargetWireAttacher<MetroWsdlWireTargetDefinition> {
    private FeatureResolver resolver;
    private SecurityEnvironment securityEnvironment;
    private ExecutorService executorService;
    private ArtifactCache cache;

    public MetroWsdlTargetWireAttacher(@Reference FeatureResolver resolver, @Reference EndpointService endpointService, @Reference SecurityEnvironment securityEnvironment, @Reference(name="executorService") ExecutorService executorService, @Reference BindingHandlerRegistry handlerRegistry, @Reference ArtifactCache cache) {
        super(handlerRegistry, endpointService);
        this.resolver = resolver;
        this.securityEnvironment = securityEnvironment;
        this.executorService = executorService;
        this.cache = cache;
    }

    public void attach(PhysicalWireSourceDefinition source, MetroWsdlWireTargetDefinition target, Wire wire) throws ContainerException {
        URL wsdlLocation;
        ReferenceEndpointDefinition endpointDefinition = target.getEndpointDefinition();
        List<QName> requestedIntents = target.getIntents();
        WebServiceFeature[] features = this.resolver.getFeatures(requestedIntents);
        String wsdl = target.getWsdl();
        try {
            URI servicePath = target.getEndpointDefinition().getUrl().toURI();
            wsdlLocation = this.cache.cache(servicePath, (InputStream)new ByteArrayInputStream(wsdl.getBytes()));
        }
        catch (URISyntaxException | CacheException e) {
            throw new ContainerException(e);
        }
        SecurityConfiguration securityConfiguration = target.getSecurityConfiguration();
        ConnectionConfiguration connectionConfiguration = target.getConnectionConfiguration();
        List<Handler> handlers = this.createHandlers(target);
        MetroDispatchObjectFactory proxyFactory = new MetroDispatchObjectFactory(endpointDefinition, wsdlLocation, null, securityConfiguration, connectionConfiguration, handlers, features, this.executorService, this.securityEnvironment);
        for (InvocationChain chain : wire.getInvocationChains()) {
            boolean oneWay = chain.getPhysicalOperation().isOneWay();
            MetroDispatchTargetInterceptor targetInterceptor = new MetroDispatchTargetInterceptor(proxyFactory, oneWay);
            chain.addInterceptor((Interceptor)targetInterceptor);
        }
    }

    public ObjectFactory<?> createObjectFactory(MetroWsdlWireTargetDefinition target) throws ContainerException {
        return null;
    }

    public void detach(PhysicalWireSourceDefinition source, MetroWsdlWireTargetDefinition target) throws ContainerException {
        try {
            this.cache.remove(target.getUri());
        }
        catch (CacheException e) {
            throw new ContainerException((Throwable)e);
        }
    }
}

