/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import com.sun.xml.wss.SecurityEnvironment;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.MetroJavaWireTargetDefinition;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.provision.SecurityConfiguration;
import org.fabric3.binding.ws.metro.runtime.core.CallbackAddressResolverImpl;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.fabric3.binding.ws.metro.runtime.core.InterceptorMonitor;
import org.fabric3.binding.ws.metro.runtime.core.MetroJavaTargetInterceptor;
import org.fabric3.binding.ws.metro.runtime.core.MetroProxyObjectFactory;
import org.fabric3.binding.ws.metro.runtime.policy.FeatureResolver;
import org.fabric3.binding.ws.metro.runtime.wire.AbstractMetroTargetWireAttacher;
import org.fabric3.binding.ws.metro.runtime.wire.WireAttacherHelper;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.binding.handler.BindingHandlerRegistry;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.fabric3.spi.repository.ArtifactCache;
import org.fabric3.spi.repository.CacheException;
import org.fabric3.spi.xml.XMLFactory;
import org.oasisopen.sca.annotation.Reference;

public class MetroJavaTargetWireAttacher
extends AbstractMetroTargetWireAttacher<MetroJavaWireTargetDefinition> {
    public static final CallbackAddressResolverImpl ADDRESS_RESOLVER = new CallbackAddressResolverImpl();
    private ClassLoaderRegistry registry;
    private FeatureResolver resolver;
    private WireAttacherHelper wireAttacherHelper;
    private ArtifactCache artifactCache;
    private SecurityEnvironment securityEnvironment;
    private ExecutorService executorService;
    private XMLInputFactory xmlInputFactory;
    private InterceptorMonitor monitor;

    public MetroJavaTargetWireAttacher(@Reference ClassLoaderRegistry registry, @Reference FeatureResolver resolver, @Reference EndpointService endpointService, @Reference WireAttacherHelper wireAttacherHelper, @Reference ArtifactCache artifactCache, @Reference SecurityEnvironment securityEnvironment, @Reference(name="executorService") ExecutorService executorService, @Reference XMLFactory xmlFactory, @Reference BindingHandlerRegistry handlerRegistry, @Monitor InterceptorMonitor monitor) {
        super(handlerRegistry, endpointService);
        this.registry = registry;
        this.resolver = resolver;
        this.wireAttacherHelper = wireAttacherHelper;
        this.artifactCache = artifactCache;
        this.securityEnvironment = securityEnvironment;
        this.executorService = executorService;
        this.xmlInputFactory = xmlFactory.newInputFactoryInstance();
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(PhysicalWireSourceDefinition source, MetroJavaWireTargetDefinition target, Wire wire) throws ContainerException {
        try {
            ReferenceEndpointDefinition endpointDefinition = target.getEndpointDefinition();
            URI classLoaderId = target.getSEIClassLoaderUri();
            List<QName> requestedIntents = target.getIntents();
            ClassLoader classLoader = this.registry.getClassLoader(classLoaderId);
            String interfaze = target.getInterface();
            byte[] bytes = target.getGeneratedInterface();
            if (!(classLoader instanceof SecureClassLoader)) {
                throw new ContainerException("Classloader for " + interfaze + " must be a SecureClassLoader");
            }
            Class<?> seiClass = this.wireAttacherHelper.loadSEI(interfaze, bytes, (SecureClassLoader)classLoader);
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                URL wsdlLocation = target.getWsdlLocation();
                URL generatedWsdl = null;
                URI servicePath = target.getEndpointDefinition().getUrl().toURI();
                String wsdl = target.getWsdl();
                if (wsdl != null) {
                    generatedWsdl = wsdlLocation = this.artifactCache.cache(servicePath, (InputStream)new ByteArrayInputStream(wsdl.getBytes()));
                    this.cacheSchemas(servicePath, target);
                }
                WebServiceFeature[] features = this.resolver.getFeatures(requestedIntents);
                SecurityConfiguration securityConfiguration = target.getSecurityConfiguration();
                ConnectionConfiguration connectionConfiguration = target.getConnectionConfiguration();
                List<Handler> handlers = this.createHandlers(target);
                CallbackAddressResolverImpl addressResolver = target.isCallback() ? ADDRESS_RESOLVER : null;
                MetroProxyObjectFactory proxyFactory = new MetroProxyObjectFactory(endpointDefinition, wsdlLocation, generatedWsdl, seiClass, features, securityConfiguration, connectionConfiguration, handlers, this.executorService, this.securityEnvironment, addressResolver, this.xmlInputFactory);
                this.attachInterceptors(seiClass, target, wire, proxyFactory);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        catch (URISyntaxException | CacheException e) {
            throw new ContainerException(e);
        }
    }

    public ObjectFactory<?> createObjectFactory(MetroJavaWireTargetDefinition target) throws ContainerException {
        return null;
    }

    public void detach(PhysicalWireSourceDefinition source, MetroJavaWireTargetDefinition target) throws ContainerException {
    }

    private List<URL> cacheSchemas(URI servicePath, MetroJavaWireTargetDefinition target) throws CacheException {
        ArrayList<URL> schemas = new ArrayList<URL>();
        for (Map.Entry<String, String> entry : target.getSchemas().entrySet()) {
            URI uri = URI.create(servicePath + "/" + entry.getKey());
            ByteArrayInputStream bas = new ByteArrayInputStream(entry.getValue().getBytes());
            URL url = this.artifactCache.cache(uri, (InputStream)bas);
            schemas.add(url);
        }
        return schemas;
    }

    private void attachInterceptors(Class<?> seiClass, MetroJavaWireTargetDefinition target, Wire wire, ObjectFactory<?> factory) {
        Method[] methods = seiClass.getMethods();
        int retries = target.getRetries();
        for (InvocationChain chain : wire.getInvocationChains()) {
            Method method = null;
            for (Method m : methods) {
                if (!chain.getPhysicalOperation().getName().equals(m.getName())) continue;
                method = m;
                break;
            }
            boolean oneWay = chain.getPhysicalOperation().isOneWay();
            MetroJavaTargetInterceptor targetInterceptor = new MetroJavaTargetInterceptor(factory, method, oneWay, retries, this.monitor);
            chain.addInterceptor((Interceptor)targetInterceptor);
        }
    }
}

