/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.Handler;
import org.fabric3.binding.ws.metro.provision.MetroWireTargetDefinition;
import org.fabric3.binding.ws.metro.runtime.core.CallbackTargetHandler;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.fabric3.binding.ws.metro.runtime.core.ReferenceCallbackAddressHandler;
import org.fabric3.binding.ws.metro.runtime.core.SOAPMessageHandlerAdapter;
import org.fabric3.spi.container.binding.handler.BindingHandler;
import org.fabric3.spi.container.binding.handler.BindingHandlerRegistry;
import org.fabric3.spi.container.builder.component.TargetWireAttacher;
import org.fabric3.spi.model.physical.PhysicalBindingHandlerDefinition;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;

public abstract class AbstractMetroTargetWireAttacher<T extends PhysicalWireTargetDefinition>
implements TargetWireAttacher<T> {
    private BindingHandlerRegistry handlerRegistry;
    private EndpointService endpointService;

    public AbstractMetroTargetWireAttacher(BindingHandlerRegistry handlerRegistry, EndpointService endpointService) {
        this.handlerRegistry = handlerRegistry;
        this.endpointService = endpointService;
    }

    protected List<Handler> createHandlers(MetroWireTargetDefinition target) {
        if (target.getHandlers().isEmpty() && !target.isBidirectional() && !target.isCallback()) {
            return null;
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        if (target.isBidirectional()) {
            ReferenceCallbackAddressHandler callbackHandler = new ReferenceCallbackAddressHandler(target.getCallbackUri(), this.endpointService);
            handlers.add((Handler)callbackHandler);
        } else if (target.isCallback()) {
            CallbackTargetHandler handler = new CallbackTargetHandler();
            handlers.add((Handler)handler);
        }
        for (PhysicalBindingHandlerDefinition handlerDefinition : target.getHandlers()) {
            BindingHandler handler = this.handlerRegistry.createHandler(SOAPMessage.class, handlerDefinition);
            SOAPMessageHandlerAdapter adaptor = new SOAPMessageHandlerAdapter((BindingHandler<SOAPMessage>)handler);
            handlers.add((Handler)adaptor);
        }
        return handlers;
    }
}

