/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.wire;

import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.Handler;
import org.fabric3.binding.ws.metro.provision.MetroWireSourceDefinition;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.fabric3.binding.ws.metro.runtime.core.SOAPMessageHandlerAdapter;
import org.fabric3.binding.ws.metro.runtime.core.ServiceCallbackAddressHandler;
import org.fabric3.spi.container.binding.handler.BindingHandler;
import org.fabric3.spi.container.binding.handler.BindingHandlerRegistry;
import org.fabric3.spi.container.builder.component.SourceWireAttacher;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.model.physical.PhysicalBindingHandlerDefinition;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;

public abstract class AbstractMetroSourceWireAttacher<T extends MetroWireSourceDefinition>
implements SourceWireAttacher<T> {
    protected EndpointService endpointService;
    private BindingHandlerRegistry handlerRegistry;

    public AbstractMetroSourceWireAttacher(EndpointService endpointService, BindingHandlerRegistry handlerRegistry) {
        this.endpointService = endpointService;
        this.handlerRegistry = handlerRegistry;
    }

    public void detachObjectFactory(T source, PhysicalWireTargetDefinition target) {
    }

    public void attachObjectFactory(T source, ObjectFactory<?> objectFactory, PhysicalWireTargetDefinition target) {
        throw new UnsupportedOperationException();
    }

    protected List<Handler> createHandlers(MetroWireSourceDefinition source) {
        if (source.getHandlers().isEmpty() && !source.isBidirectional()) {
            return null;
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        if (source.isBidirectional()) {
            ServiceCallbackAddressHandler callbackHandler = new ServiceCallbackAddressHandler();
            handlers.add((Handler)callbackHandler);
        }
        for (PhysicalBindingHandlerDefinition handlerDefinition : source.getHandlers()) {
            BindingHandler handler = this.handlerRegistry.createHandler(SOAPMessage.class, handlerDefinition);
            SOAPMessageHandlerAdapter soapHandlerAdaptor = new SOAPMessageHandlerAdapter((BindingHandler<SOAPMessage>)handler);
            handlers.add((Handler)soapHandlerAdaptor);
        }
        return handlers;
    }
}

