/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.security;

import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.fabric3.binding.ws.metro.runtime.security.CertificateValidator;

public class CertificateValidatorImpl
implements CertificateValidator {
    @Override
    public boolean validate(X509Certificate certificate, KeyStore trustStore) throws XWSSecurityRuntimeException {
        try {
            certificate.checkValidity();
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
        if (certificate.getIssuerX500Principal().equals(certificate.getSubjectX500Principal())) {
            if (CertificateValidatorImpl.isTrustedSelfSigned(certificate, trustStore)) {
                return true;
            }
            throw new XWSSecurityRuntimeException("Validation of self signed certificate failed");
        }
        X509CertSelector certSelector = new X509CertSelector();
        certSelector.setCertificate(certificate);
        List<Object> certChainList = new ArrayList<X509Certificate>();
        boolean caFound = false;
        Principal certChainIssuer = null;
        int noOfEntriesInTrustStore = 0;
        boolean isIssuerCertMatched = false;
        try {
            PKIXBuilderParameters parameters = new PKIXBuilderParameters(trustStore, (CertSelector)certSelector);
            parameters.setRevocationEnabled(false);
            CertStore cs = CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singleton(certificate)));
            parameters.addCertStore(cs);
            Certificate[] certChain = null;
            String certAlias = trustStore.getCertificateAlias(certificate);
            if (certAlias != null) {
                certChain = trustStore.getCertificateChain(certAlias);
            }
            if (certChain == null) {
                certChainList.add(certificate);
                certChainIssuer = certificate.getIssuerX500Principal();
                noOfEntriesInTrustStore = trustStore.size();
            } else {
                certChainList = Arrays.asList(certChain);
            }
            while (!caFound && noOfEntriesInTrustStore-- != 0 && certChain == null) {
                Enumeration<String> aliases = trustStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate x509Cert;
                    String alias = aliases.nextElement();
                    Certificate cert = trustStore.getCertificate(alias);
                    if (cert == null || !"X.509".equals(cert.getType()) || certChainList.contains(cert) || !certChainIssuer.equals((x509Cert = (X509Certificate)cert).getSubjectX500Principal())) continue;
                    certChainList.add(cert);
                    if (x509Cert.getSubjectX500Principal().equals(x509Cert.getIssuerX500Principal())) {
                        caFound = true;
                        break;
                    }
                    certChainIssuer = x509Cert.getIssuerDN();
                    if (isIssuerCertMatched) continue;
                    isIssuerCertMatched = true;
                }
                if (caFound) continue;
                if (!isIssuerCertMatched) break;
                isIssuerCertMatched = false;
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            CertPath certPath = cf.generateCertPath(certChainList);
            CertPathValidator certValidator = CertPathValidator.getInstance("PKIX");
            certValidator.validate(certPath, parameters);
            return true;
        }
        catch (InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | CertPathValidatorException | CertificateException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
    }

    private static boolean isTrustedSelfSigned(X509Certificate cert, KeyStore trustStore) throws XWSSecurityRuntimeException {
        try {
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate x509Cert;
                String alias = aliases.nextElement();
                Certificate certificate = trustStore.getCertificate(alias);
                if (certificate == null || !"X.509".equals(certificate.getType()) || !(x509Cert = (X509Certificate)certificate).equals(cert)) continue;
                return true;
            }
            return false;
        }
        catch (KeyStoreException e) {
            throw new XWSSecurityRuntimeException((Throwable)e);
        }
    }
}

