/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.oasisopen.sca.ServiceRuntimeException;

public class ServiceCallbackAddressHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final String WSA = "http://www.w3.org/2005/08/addressing";
    private static final QName WSA_REFERENCE_PARAMETERS = new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters");
    private static final QName WSA_ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "Address");
    private static final QName WSA_REPLY_TO = new QName("http://www.w3.org/2005/08/addressing", "ReplyTo");
    private static final QName WSA_FROM = new QName("http://www.w3.org/2005/08/addressing", "From");
    private static final String WSA_ANONYMOUS = "http://www.w3.org/2005/08/addressing/anonymous";
    public static final QName WSA_MESSAGE_ID = new QName("http://www.w3.org/2005/08/addressing", "MessageID");

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext soapContext) {
        SOAPMessage soapMessage = soapContext.getMessage();
        if (soapMessage == null) {
            return true;
        }
        WorkContext workContext = WorkContextCache.getThreadWorkContext();
        Object object = workContext = workContext == null ? soapContext.get((Object)"f3.work.context") : workContext;
        if (workContext == null) {
            throw new ServiceRuntimeException("Work context not set");
        }
        try {
            Iterator messageIdHeaders;
            Iterator replyToHeaders;
            SOAPHeader soapHeader = soapMessage.getSOAPHeader();
            if (soapHeader == null) {
                return true;
            }
            Iterator fromHeaders = soapHeader.getChildElements(WSA_FROM);
            if (fromHeaders.hasNext()) {
                SOAPElement fromElement = (SOAPElement)fromHeaders.next();
                this.setReturnAddress(fromElement, workContext);
                this.setReferenceParameters(fromElement, workContext);
            }
            if ((replyToHeaders = soapHeader.getChildElements(WSA_REPLY_TO)).hasNext()) {
                SOAPElement replyToElement = (SOAPElement)replyToHeaders.next();
                this.setReturnAddress(replyToElement, workContext);
            }
            if ((messageIdHeaders = soapHeader.getChildElements(WSA_MESSAGE_ID)).hasNext()) {
                SOAPElement messageIdHeader = (SOAPElement)messageIdHeaders.next();
                String messageId = messageIdHeader.getFirstChild().getNodeValue();
                workContext.setHeader("f3.message.id", (Object)messageId);
            }
        }
        catch (SOAPException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }

    private void setReturnAddress(SOAPElement element, WorkContext workContext) {
        Iterator addresses = element.getChildElements(WSA_ADDRESS);
        if (addresses.hasNext()) {
            String address = ((SOAPElement)addresses.next()).getValue();
            if (WSA_ANONYMOUS.equals(address)) {
                throw new ProtocolException("Invalid Callback Address: http://www.w3.org/2005/08/addressing/anonymous");
            }
            if (address != null) {
                workContext.setHeader("f3.callback.address", (Object)address);
            }
        }
    }

    private void setReferenceParameters(SOAPElement fromElement, WorkContext workContext) {
        Iterator referenceParameters = fromElement.getChildElements(WSA_REFERENCE_PARAMETERS);
        if (!referenceParameters.hasNext()) {
            return;
        }
        SOAPElement referenceParameter = (SOAPElement)referenceParameters.next();
        Iterator values = referenceParameter.getChildElements();
        if (!values.hasNext()) {
            return;
        }
        HashMap<QName, String> parameters = new HashMap<QName, String>();
        while (values.hasNext()) {
            SOAPElement element = (SOAPElement)values.next();
            QName name = element.getElementQName();
            String value = element.getValue();
            parameters.put(name, value);
        }
        workContext.setHeader("f3.reference.parameters", parameters);
    }
}

