/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import java.net.URI;
import java.net.URL;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.fabric3.binding.ws.metro.runtime.core.EndpointService;
import org.oasisopen.sca.ServiceRuntimeException;

public class ReferenceCallbackAddressHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final String WSA = "http://www.w3.org/2005/08/addressing";
    private URI callbackUri;
    private EndpointService endpointService;
    private URL callbackAddress;

    public ReferenceCallbackAddressHandler(URI callbackUri, EndpointService endpointService) {
        this.callbackUri = callbackUri;
        this.endpointService = endpointService;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        if (this.callbackAddress == null) {
            this.callbackAddress = this.endpointService.getEndpointUrl(this.callbackUri);
        }
        try {
            SOAPMessage soapMessage = context.getMessage();
            SOAPHeader header = soapMessage.getSOAPHeader();
            SOAPEnvelope envelope = soapMessage.getSOAPPart().getEnvelope();
            SOAPHeaderElement element = header.addHeaderElement(envelope.createName("From", "wsa", WSA));
            element.addChildElement(envelope.createName("Address", "wsa", WSA)).addTextNode(this.callbackAddress.toString());
        }
        catch (SOAPException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

