/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import com.sun.xml.ws.wsdl.parser.InaccessibleWSDLException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Dispatch;
import org.fabric3.binding.ws.metro.runtime.core.AbstractMetroTargetInterceptor;
import org.fabric3.binding.ws.metro.runtime.core.MetroDispatchObjectFactory;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.objectfactory.ObjectCreationException;
import org.oasisopen.sca.ServiceRuntimeException;
import org.w3c.dom.Node;

public class MetroDispatchTargetInterceptor
extends AbstractMetroTargetInterceptor {
    private MetroDispatchObjectFactory proxyFactory;
    private boolean oneWay;
    private TransformerFactory transformerFactory;

    public MetroDispatchTargetInterceptor(MetroDispatchObjectFactory dispatchFactory, boolean oneWay) {
        this.proxyFactory = dispatchFactory;
        this.oneWay = oneWay;
        this.transformerFactory = TransformerFactory.newInstance();
    }

    public Message invoke(Message msg) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Object[] payload = (Object[])msg.getBody();
            if (payload.length != 1) {
                throw new IllegalArgumentException("Payload must contain a single parameter");
            }
            if (!(payload[0] instanceof Node)) {
                throw new IllegalArgumentException("Payload must be a Node");
            }
            Node parameter = (Node)payload[0];
            Dispatch<Source> dispatch = this.proxyFactory.getInstance();
            DOMSource source = new DOMSource(parameter);
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (this.oneWay) {
                dispatch.invokeAsync((Object)source, null);
                Message message = NULL_RESPONSE;
                return message;
            }
            Object ret = dispatch.invoke((Object)source);
            if (!(ret instanceof Source)) {
                throw new ServiceRuntimeException("Returned object must be a " + Source.class.getName());
            }
            Source returnSource = (Source)ret;
            Transformer transformer = this.transformerFactory.newTransformer();
            DOMResult result = new DOMResult();
            transformer.transform(returnSource, result);
            msg.setBody((Object)result.getNode());
            Message message = msg;
            return message;
        }
        catch (InaccessibleWSDLException | TransformerException | ObjectCreationException e) {
            throw new ServiceRuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

