/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageCache;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.w3c.dom.Document;

public class DocumentInvoker
extends Invoker {
    private Map<String, InvocationChain> chains = new HashMap<String, InvocationChain>();
    private MessageFactory factory;

    public DocumentInvoker(List<InvocationChain> chains) {
        for (InvocationChain chain : chains) {
            this.chains.put(chain.getPhysicalOperation().getName(), chain);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.factory = MessageFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public Object invoke(Packet packet, Method method, Object ... args) throws InvocationTargetException {
        if (args.length != 1) {
            throw new UnsupportedOperationException("Illegal number of arguments");
        }
        if (!(args[0] instanceof SOAPMessage)) {
            throw new UnsupportedOperationException("Expected SOAPMessage but was: " + args[0].getClass());
        }
        WorkContext workContext = (WorkContext)packet.invocationProperties.get("f3.work.context");
        if (workContext == null) {
            throw new AssertionError((Object)"Work context not set");
        }
        Message input = MessageCache.getAndResetMessage();
        try {
            SOAPMessage soapMessage = (SOAPMessage)args[0];
            Document node = soapMessage.getSOAPBody().extractContentAsDocument();
            input.setWorkContext(workContext);
            input.setBody((Object)node);
            String operationName = packet.getWSDLOperation().getLocalPart();
            if (operationName == null) {
                throw new AssertionError((Object)("No invocation chain found for WSDL operation: " + operationName));
            }
            Interceptor head = this.chains.get(operationName).getHeadInterceptor();
            Message ret = head.invoke(input);
            Object body = ret.getBody();
            if (!ret.isFault()) {
                SOAPMessage sOAPMessage = this.createResponse(body);
                return sOAPMessage;
            }
            SOAPMessage sOAPMessage = this.createFault((Throwable)body);
            return sOAPMessage;
        }
        catch (SOAPException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            input.reset();
        }
    }

    public void start(WebServiceContext wsc) {
    }

    private SOAPMessage createResponse(Object body) throws InvocationTargetException {
        try {
            SOAPMessage soapMessage = this.factory.createMessage();
            soapMessage.getSOAPBody().addDocument((Document)body);
            soapMessage.saveChanges();
            return soapMessage;
        }
        catch (SOAPException e) {
            throw new InvocationTargetException(e);
        }
    }

    private SOAPMessage createFault(Throwable e) {
        try {
            com.sun.xml.ws.api.message.Message fault = SOAPFaultBuilder.createSOAPFaultMessage((SOAPVersion)SOAPVersion.SOAP_11, null, (Throwable)e);
            return fault.readAsSOAPMessage();
        }
        catch (SOAPException e2) {
            throw new WebServiceException((Throwable)e2);
        }
    }
}

