/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.runtime.core;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.oasisopen.sca.ServiceRuntimeException;

public class CallbackTargetHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final String WSA = "http://www.w3.org/2005/08/addressing";
    private static final QName WSA_RELATES_TO = new QName("http://www.w3.org/2005/08/addressing", "RelatesTo");
    private static final QName WSA_RELATIONSHIP_TYPE = new QName("http://www.w3.org/2005/08/addressing", "RelationshipType");
    private static final String SCA_CALLBACK_RELATIONSHIP = "http://docs.oasis-open.org/opencsa/sca-bindings/ws/callback";

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext soapContext) {
        WorkContext workContext = WorkContextCache.getThreadWorkContext();
        Object object = workContext = workContext == null ? soapContext.get((Object)"f3.work.context") : workContext;
        if (workContext == null) {
            throw new ServiceRuntimeException("Work context not set");
        }
        soapContext.put((Object)"javax.xml.ws.service.endpoint.address", workContext.getHeader(String.class, "f3.callback.address"));
        try {
            this.handleRelatesToHeader(soapContext, workContext);
            this.handleReferenceParameters(soapContext, workContext);
        }
        catch (SOAPException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }

    private void handleRelatesToHeader(SOAPMessageContext soapContext, WorkContext workContext) throws SOAPException {
        String messageId = (String)workContext.getHeader(String.class, "f3.message.id");
        if (messageId == null) {
            return;
        }
        SOAPHeader soapHeader = soapContext.getMessage().getSOAPHeader();
        SOAPHeaderElement relatesToHeader = soapHeader.addHeaderElement(WSA_RELATES_TO);
        relatesToHeader.setValue(messageId);
        relatesToHeader.addAttribute(WSA_RELATIONSHIP_TYPE, SCA_CALLBACK_RELATIONSHIP);
    }

    private void handleReferenceParameters(SOAPMessageContext soapContext, WorkContext workContext) throws SOAPException {
        Map parameters = (Map)workContext.getHeader(Map.class, "f3.reference.parameters");
        if (parameters == null) {
            return;
        }
        SOAPHeader soapHeader = soapContext.getMessage().getSOAPHeader();
        for (Map.Entry entry : parameters.entrySet()) {
            SOAPHeaderElement headerElement = soapHeader.addHeaderElement((QName)entry.getKey());
            headerElement.setValue((String)entry.getValue());
        }
    }
}

