/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.validator;

import java.net.URI;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.fabric3.api.binding.ws.model.WsBindingDefinition;
import org.fabric3.api.host.contribution.StoreException;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.binding.ws.metro.generator.validator.EndpointValidationException;
import org.fabric3.binding.ws.metro.generator.validator.WsdlEndpointValidator;
import org.fabric3.binding.ws.metro.provision.AbstractEndpointDefinition;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.wsdl.contribution.BindingSymbol;
import org.fabric3.wsdl.contribution.PortSymbol;
import org.fabric3.wsdl.contribution.WsdlServiceContractSymbol;
import org.fabric3.wsdl.model.WsdlServiceContract;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class WsdlEndpointValidatorImpl
implements WsdlEndpointValidator {
    private static final String SOAP_HTTP_TRANSPORT = "http://schemas.xmlsoap.org/soap/http";
    private MetaDataStore store;
    private ContractMatcher matcher;
    private boolean enabled;

    public WsdlEndpointValidatorImpl(@Reference MetaDataStore store, @Reference ContractMatcher matcher) {
        this.store = store;
        this.matcher = matcher;
    }

    @Property(required=false)
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void validate(URI contributionUri, LogicalBinding<WsBindingDefinition> binding, AbstractEndpointDefinition endpointDefinition) throws EndpointValidationException {
        if (!this.enabled) {
            return;
        }
        try {
            ServiceContract otherContract = ((Bindable)binding.getParent()).getServiceContract();
            DefaultIntrospectionContext context = new DefaultIntrospectionContext();
            PortSymbol portSymbol = new PortSymbol(endpointDefinition.getPortName());
            QName name = ((Port)this.store.resolve(contributionUri, Port.class, (Symbol)portSymbol, (IntrospectionContext)context).getValue()).getBinding().getPortType().getQName();
            WsdlServiceContractSymbol contractSymbol = new WsdlServiceContractSymbol(name);
            WsdlServiceContract contract = (WsdlServiceContract)this.store.resolve(contributionUri, WsdlServiceContract.class, (Symbol)contractSymbol, (IntrospectionContext)context).getValue();
            MatchResult result = this.matcher.isAssignableFrom((ServiceContract)contract, otherContract, true);
            if (!result.isAssignable()) {
                throw new EndpointValidationException(result.getError());
            }
        }
        catch (StoreException e) {
            throw new EndpointValidationException(e);
        }
    }

    @Override
    public void validateBinding(URI contributionUri, LogicalBinding<WsBindingDefinition> binding, QName bindingName) throws EndpointValidationException {
        if (!this.enabled) {
            return;
        }
        try {
            ServiceContract otherContract = ((Bindable)binding.getParent()).getServiceContract();
            DefaultIntrospectionContext context = new DefaultIntrospectionContext();
            BindingSymbol bindingSymbol = new BindingSymbol(bindingName);
            Binding wsdlBinding = (Binding)this.store.resolve(contributionUri, Binding.class, (Symbol)bindingSymbol, (IntrospectionContext)context).getValue();
            QName portTypeName = wsdlBinding.getPortType().getQName();
            WsdlServiceContractSymbol contractSymbol = new WsdlServiceContractSymbol(portTypeName);
            WsdlServiceContract contract = (WsdlServiceContract)this.store.resolve(contributionUri, WsdlServiceContract.class, (Symbol)contractSymbol, (IntrospectionContext)context).getValue();
            MatchResult result = this.matcher.isAssignableFrom(otherContract, (ServiceContract)contract, true);
            if (!result.isAssignable()) {
                throw new EndpointValidationException(result.getError());
            }
            for (Object element : wsdlBinding.getExtensibilityElements()) {
                if (element instanceof SOAPBinding) {
                    SOAPBinding soapBinding = (SOAPBinding)element;
                    if (SOAP_HTTP_TRANSPORT.equals(soapBinding.getTransportURI())) continue;
                    throw new EndpointValidationException("Invalid SOAP binding transport specified for: " + ((Bindable)binding.getParent()).getUri());
                }
                if (!(element instanceof SOAP12Binding) || !binding.getIntents().contains(new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "SOAP.v1_1"))) continue;
                throw new EndpointValidationException("Invalid intents configuration: SOAP 1.1 and SOAP 1.2 specified");
            }
        }
        catch (StoreException e) {
            throw new EndpointValidationException(e);
        }
    }
}

