/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.resolver;

import java.net.MalformedURLException;
import java.net.URL;
import org.fabric3.api.binding.ws.model.WsBindingDefinition;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.api.model.type.definitions.Intent;
import org.fabric3.binding.ws.metro.generator.resolver.TargetUrlResolver;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.policy.EffectivePolicy;
import org.fabric3.spi.host.ServletHost;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.oasisopen.sca.annotation.Reference;

public class TargetUrlResolverImpl
implements TargetUrlResolver {
    private ServletHost servletHost;
    private HostInfo hostInfo;

    public TargetUrlResolverImpl(@Reference ServletHost servletHost, @Reference HostInfo hostInfo) {
        this.servletHost = servletHost;
        this.hostInfo = hostInfo;
    }

    @Override
    public URL resolveUrl(LogicalBinding<WsBindingDefinition> serviceBinding, EffectivePolicy policy) throws GenerationException {
        try {
            URL targetUrl;
            String path = ((WsBindingDefinition)serviceBinding.getDefinition()).getTargetUri().toString();
            if (path == null) {
                path = ((Bindable)serviceBinding.getParent()).getUri().getFragment();
            }
            boolean https = this.requiresHttps(policy);
            if (RuntimeMode.VM == this.hostInfo.getRuntimeMode()) {
                targetUrl = https ? new URL("https://localhost:" + this.servletHost.getHttpsPort() + "/" + path) : new URL("http://localhost:" + this.servletHost.getHttpPort() + "/" + path);
            } else {
                throw new GenerationException("Resolve URL not supported in distributed configuration");
            }
            return targetUrl;
        }
        catch (MalformedURLException e) {
            throw new GenerationException((Throwable)e);
        }
    }

    private boolean requiresHttps(EffectivePolicy policy) {
        for (Intent intent : policy.getProvidedEndpointIntents()) {
            String localPart = intent.getName().getLocalPart();
            if (!localPart.startsWith("authorization") && !localPart.equals("integrity") && !localPart.startsWith("confidentiality") && !localPart.startsWith("mutualAuthentication") && !localPart.equals("authentication") && !localPart.startsWith("clientAuthentication") && !localPart.startsWith("serverAuthentication")) continue;
            return true;
        }
        return false;
    }
}

