/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.resolver;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.fabric3.binding.ws.metro.generator.WsdlElement;
import org.fabric3.binding.ws.metro.generator.resolver.EndpointResolutionException;
import org.fabric3.binding.ws.metro.generator.resolver.EndpointResolver;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.provision.ServiceEndpointDefinition;
import org.fabric3.wsdl.contribution.Wsdl4JFactory;
import org.oasisopen.sca.annotation.Reference;

public class EndpointResolverImpl
implements EndpointResolver {
    private static final QName SOAP11_ADDRESS = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address");
    private static final QName SOAP12_ADDRESS_OLD = new QName("http://www.w3.org/2003/05/soap/bindings/HTTP/", "address");
    private static final QName SOAP12_ADDRESS = new QName("http://schemas.xmlsoap.org/wsdl/soap12/", "address");
    private static final String SOAP_HTTP_TRANSPORT = "http://schemas.xmlsoap.org/soap/http";
    private Wsdl4JFactory wsdlFactory;

    public EndpointResolverImpl(@Reference Wsdl4JFactory wsdlFactory) {
        this.wsdlFactory = wsdlFactory;
    }

    @Override
    public ServiceEndpointDefinition resolveServiceEndpoint(WsdlElement wsdlElement, Definition wsdl) throws EndpointResolutionException {
        return this.resolveServiceEndpoint(wsdlElement, wsdl, null);
    }

    @Override
    public ServiceEndpointDefinition resolveServiceEndpoint(WsdlElement wsdlElement, Definition wsdl, URI uri) throws EndpointResolutionException {
        URI servicePath;
        QName serviceName = wsdlElement.getServiceName();
        QName portName = wsdlElement.getPortName();
        Port port = this.resolveAndValidatePort(serviceName, portName, wsdl);
        if (uri == null) {
            URL url = this.getAddress(port);
            servicePath = URI.create(url.getPath());
        } else {
            servicePath = uri;
        }
        String serializedWsdl = this.serializeWsdl(wsdl);
        return new ServiceEndpointDefinition(serviceName, portName, servicePath, serializedWsdl);
    }

    @Override
    public ReferenceEndpointDefinition resolveReferenceEndpoint(WsdlElement wsdlElement, Definition wsdl) throws EndpointResolutionException {
        QName serviceName = wsdlElement.getServiceName();
        QName portName = wsdlElement.getPortName();
        Port port = this.resolveAndValidatePort(serviceName, portName, wsdl);
        URL url = this.getAddress(port);
        QName portTypeName = port.getBinding().getPortType().getQName();
        String serializedWsdl = this.serializeWsdl(wsdl);
        return new ReferenceEndpointDefinition(serviceName, true, portName, portTypeName, url, serializedWsdl);
    }

    @Override
    public String serializeWsdl(Definition wsdl) throws EndpointResolutionException {
        try {
            WSDLWriter writer = this.wsdlFactory.newWriter();
            StringWriter stringWriter = new StringWriter();
            writer.writeWSDL(wsdl, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (WSDLException e) {
            throw new EndpointResolutionException(e);
        }
    }

    private Port resolveAndValidatePort(QName serviceName, QName portName, Definition wsdl) throws EndpointResolutionException {
        Port port;
        Service service = wsdl.getService(serviceName);
        if (service == null) {
            throw new EndpointResolutionException("WSDL service not found: " + serviceName);
        }
        if (portName == null) {
            if (service.getPorts().isEmpty()) {
                throw new EndpointResolutionException("No WSDL ports defined: " + serviceName);
            }
            port = (Port)service.getPorts().values().iterator().next();
        } else {
            port = service.getPort(portName.getLocalPart());
            if (port == null) {
                throw new EndpointResolutionException("WSDL port not found: " + portName);
            }
        }
        for (Object element : port.getBinding().getExtensibilityElements()) {
            SOAPBinding binding;
            if (!(element instanceof SOAPBinding) || SOAP_HTTP_TRANSPORT.equals((binding = (SOAPBinding)element).getTransportURI())) continue;
            throw new EndpointResolutionException("Invalid SOAP binding transport specified for: " + port.getName());
        }
        return port;
    }

    private URL getAddress(Port port) throws EndpointResolutionException {
        for (Object o : port.getExtensibilityElements()) {
            ExtensibilityElement element = (ExtensibilityElement)o;
            QName elementType = element.getElementType();
            if (!SOAP11_ADDRESS.equals(elementType) && !SOAP12_ADDRESS.equals(elementType) && !SOAP12_ADDRESS_OLD.equals(elementType)) continue;
            try {
                Method m = element.getClass().getMethod("getLocationURI", new Class[0]);
                String locationURI = (String)m.invoke((Object)element, new Object[0]);
                return new URL(locationURI);
            }
            catch (MalformedURLException e) {
                throw new EndpointResolutionException("Invalid URL specified for port " + port.getName(), e);
            }
            catch (Exception e) {
                throw new EndpointResolutionException("Unable to resolve address for port " + port.getName(), e);
            }
        }
        throw new EndpointResolutionException("SOAP address not found on port " + port.getName());
    }
}

