/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.policy;

import java.util.List;
import org.fabric3.binding.ws.metro.generator.PolicyExpressionMapping;
import org.fabric3.binding.ws.metro.generator.policy.PolicyAttachmentException;
import org.fabric3.binding.ws.metro.generator.policy.WsdlPolicyAttacher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WsdlPolicyAttacherImpl
implements WsdlPolicyAttacher {
    private static final String WS_POLICY_NS = "http://www.w3.org/ns/ws-policy";
    private static final String WS_SECURITY_UTILITY_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";

    @Override
    public void attach(Document wsdl, List<Element> endpointPolicies, List<PolicyExpressionMapping> mappings) throws PolicyAttachmentException {
        this.attachEndpointPolicies(wsdl, endpointPolicies);
        this.attachOperationPolicies(wsdl, mappings);
    }

    private void attachEndpointPolicies(Document document, List<Element> endpointPolicies) throws PolicyAttachmentException {
        Element root = document.getDocumentElement();
        for (Element policy : endpointPolicies) {
            Node clone = policy.cloneNode(true);
            document.adoptNode(clone);
            root.appendChild(clone);
            Node item = clone.getAttributes().getNamedItemNS(WS_SECURITY_UTILITY_NS, "Id");
            if (item == null) {
                throw new PolicyAttachmentException("Missing id in policy expression");
            }
            String id = "#" + item.getNodeValue();
            Node bindingNode = this.findChildNode(root, "binding");
            if (bindingNode == null) {
                throw new PolicyAttachmentException("Binding element missing");
            }
            Element reference = bindingNode.getOwnerDocument().createElementNS(WS_POLICY_NS, "PolicyReference");
            reference.setAttribute("URI", id);
            bindingNode.appendChild(reference);
        }
    }

    private void attachOperationPolicies(Document document, List<PolicyExpressionMapping> mappings) throws PolicyAttachmentException {
        Element root = document.getDocumentElement();
        for (PolicyExpressionMapping mapping : mappings) {
            Element policy = mapping.getPolicyExpression();
            List<String> operationNames = mapping.getOperationNames();
            Node clone = policy.cloneNode(true);
            document.adoptNode(clone);
            root.appendChild(clone);
            Node item = clone.getAttributes().getNamedItemNS(WS_SECURITY_UTILITY_NS, "Id");
            if (item == null) {
                throw new PolicyAttachmentException("Missing id in policy expression");
            }
            String id = "#" + item.getNodeValue();
            Node portTypeNode = this.findChildNode(root, "portType");
            if (portTypeNode == null) {
                throw new PolicyAttachmentException("Port type element missing");
            }
            this.addPolicyReferenceToOperation(portTypeNode, operationNames, id);
        }
    }

    private void addPolicyReferenceToOperation(Node node, List<String> operationNames, String id) {
        Node childNode = node.getFirstChild();
        while (childNode != null) {
            Node nextChild = childNode.getNextSibling();
            if (childNode.getNodeName().equals("operation") && operationNames.contains(childNode.getAttributes().getNamedItem("name").getNodeValue())) {
                Element reference = node.getOwnerDocument().createElementNS(WS_POLICY_NS, "PolicyReference");
                reference.setAttribute("URI", id);
                childNode.appendChild(reference);
            }
            childNode = nextChild;
        }
    }

    private Node findChildNode(Node parent, String name) {
        Node childNode = parent.getFirstChild();
        while (childNode != null) {
            Node nextChild = childNode.getNextSibling();
            if (childNode.getNodeName().equals(name)) {
                return childNode;
            }
            childNode = nextChild;
        }
        return null;
    }
}

