/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.java.codegen;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.SecureClassLoader;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebService;
import org.fabric3.binding.ws.metro.generator.java.codegen.GeneratedInterface;
import org.fabric3.binding.ws.metro.generator.java.codegen.GeneratorHelper;
import org.fabric3.binding.ws.metro.generator.java.codegen.InterfaceGenerationException;
import org.fabric3.binding.ws.metro.generator.java.codegen.InterfaceGenerator;
import org.fabric3.binding.ws.metro.util.ClassDefiner;
import org.oasisopen.sca.annotation.OneWay;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

@Service(value={InterfaceGenerator.class})
public class InterfaceGeneratorImpl
implements InterfaceGenerator,
Opcodes {
    private static final String SUFFIX = "F3Subtype";
    private ClassDefiner definer;

    public InterfaceGeneratorImpl(@Reference ClassDefiner definer) {
        this.definer = definer;
    }

    @Override
    public boolean doGeneration(Class<?> clazz) {
        if (!clazz.isAnnotationPresent(WebService.class)) {
            return true;
        }
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(OneWay.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GeneratedInterface generate(Class interfaze, String targetNamespace, String wsdlLocation, String serviceName, String portName) throws InterfaceGenerationException {
        if (!(interfaze.getClassLoader() instanceof SecureClassLoader)) {
            throw new InterfaceGenerationException("Classloader for " + interfaze.getName() + " must be a SecureClassLoader");
        }
        SecureClassLoader loader = (SecureClassLoader)interfaze.getClassLoader();
        String name = interfaze.getName();
        String internalName = name.replace('.', '/');
        String generatedInternalName = internalName + SUFFIX;
        ClassWriter cw = new ClassWriter(0);
        byte[] bytes = this.generate(cw, generatedInternalName, interfaze, targetNamespace, wsdlLocation, serviceName, portName);
        String generatedName = name + SUFFIX;
        try {
            Class<?> clazz = this.definer.defineClass(generatedName, bytes, loader);
            return new GeneratedInterface(clazz, bytes);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InterfaceGenerationException(e);
        }
    }

    private byte[] generate(ClassWriter cw, String className, Class<?> clazz, String targetNamespace, String wsdlLocation, String serviceName, String portName) {
        Method[] methods;
        String[] interfaces = new String[]{clazz.getName().replace('.', '/')};
        cw.visit(49, 513, className, null, "java/lang/Object", interfaces);
        if (!clazz.isAnnotationPresent(WebService.class)) {
            AnnotationVisitor av = cw.visitAnnotation(GeneratorHelper.getSignature(WebService.class), true);
            av.visit("name", (Object)clazz.getSimpleName());
            if (targetNamespace != null) {
                av.visit("targetNamespace", (Object)targetNamespace);
            }
            if (wsdlLocation != null) {
                av.visit("wsdlLocation", (Object)wsdlLocation);
            }
            if (serviceName != null) {
                av.visit("serviceName", (Object)serviceName);
            }
            if (portName != null) {
                av.visit("portName", (Object)portName);
            }
            av.visitEnd();
        }
        for (Method m : methods = clazz.getMethods()) {
            this.generateMethod(cw, m);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateMethod(ClassWriter cw, Method m) {
        String signature = GeneratorHelper.getSignature(m);
        MethodVisitor mv = cw.visitMethod(1025, m.getName(), signature, null, null);
        if (!m.isAnnotationPresent(WebMethod.class)) {
            AnnotationVisitor av = mv.visitAnnotation(GeneratorHelper.getSignature(WebMethod.class), true);
            av.visitEnd();
        }
        if (!m.isAnnotationPresent(Oneway.class) && m.isAnnotationPresent(OneWay.class)) {
            AnnotationVisitor oneWay = mv.visitAnnotation(GeneratorHelper.getSignature(Oneway.class), true);
            oneWay.visitEnd();
        }
        mv.visitEnd();
    }
}

