/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.java.codegen;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.SecureClassLoader;
import java.util.Collection;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.fabric3.binding.ws.metro.generator.java.codegen.GeneratedInterface;
import org.fabric3.binding.ws.metro.generator.java.codegen.GeneratorHelper;
import org.fabric3.binding.ws.metro.generator.java.codegen.InterfaceFromWsdlGenerator;
import org.fabric3.binding.ws.metro.generator.java.codegen.InterfaceGenerationException;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.util.ClassDefiner;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

@Service(value={InterfaceFromWsdlGenerator.class})
public class InterfaceFromWsdlGeneratorImpl
implements InterfaceFromWsdlGenerator,
Opcodes {
    private static final String SUFFIX = "F3Subtype";
    private ClassDefiner definer;

    public InterfaceFromWsdlGeneratorImpl(@Reference ClassDefiner definer) {
        this.definer = definer;
    }

    @Override
    public boolean doGeneration(Class<?> clazz) {
        return !clazz.isAnnotationPresent(WebService.class);
    }

    @Override
    public GeneratedInterface generateRPCLit(Class interfaze, ReferenceEndpointDefinition endpointDefinition) throws InterfaceGenerationException {
        if (!(interfaze.getClassLoader() instanceof SecureClassLoader)) {
            throw new InterfaceGenerationException("Classloader for " + interfaze.getName() + " must be a SecureClassLoader");
        }
        SecureClassLoader loader = (SecureClassLoader)interfaze.getClassLoader();
        String name = interfaze.getName();
        String internalName = name.replace('.', '/');
        String generatedInternalName = internalName + SUFFIX;
        ClassWriter cw = new ClassWriter(0);
        byte[] bytes = this.generate(cw, generatedInternalName, interfaze, endpointDefinition);
        String generatedName = name + SUFFIX;
        try {
            Class<?> clazz = this.definer.defineClass(generatedName, bytes, loader);
            return new GeneratedInterface(clazz, bytes);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InterfaceGenerationException(e);
        }
    }

    private byte[] generate(ClassWriter cw, String className, Class<?> clazz, ReferenceEndpointDefinition endpointDefinition) {
        Method[] methods;
        String[] interfaces = new String[]{clazz.getName().replace('.', '/')};
        cw.visit(49, 513, className, null, "java/lang/Object", interfaces);
        endpointDefinition.getPortTypeName();
        Definition definition = endpointDefinition.getDefinition();
        if (!clazz.isAnnotationPresent(WebService.class)) {
            AnnotationVisitor av = cw.visitAnnotation(GeneratorHelper.getSignature(WebService.class), true);
            av.visit("targetNamespace", (Object)definition.getTargetNamespace());
            javax.wsdl.Service service = (javax.wsdl.Service)definition.getServices().values().iterator().next();
            av.visit("serviceName", (Object)service.getQName().getLocalPart());
            Port port = (Port)service.getPorts().values().iterator().next();
            av.visit("portName", (Object)port.getName());
            av.visitEnd();
            av = cw.visitAnnotation(GeneratorHelper.getSignature(SOAPBinding.class), true);
            av.visitEnum("style", GeneratorHelper.getSignature(SOAPBinding.Style.class), "RPC");
            av.visitEnd();
        }
        for (Method m : methods = clazz.getMethods()) {
            this.generateMethod(cw, m, definition, endpointDefinition);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateMethod(ClassWriter cw, Method m, Definition definition, ReferenceEndpointDefinition endpointDefinition) {
        QName portTypeName = endpointDefinition.getPortTypeName();
        Binding binding = null;
        Collection bindings = definition.getBindings().values();
        for (Binding entry : bindings) {
            if (!entry.getPortType().getQName().equals(portTypeName)) continue;
            binding = entry;
            break;
        }
        if (binding == null) {
            throw new AssertionError();
        }
        BindingOperation bindingOperation = null;
        List bindingOperations = binding.getBindingOperations();
        for (BindingOperation operation : bindingOperations) {
            if (!operation.getName().equals(m.getName())) continue;
            bindingOperation = operation;
            break;
        }
        SOAPOperation soapOperation = null;
        for (Object element : bindingOperation.getExtensibilityElements()) {
            if (!(element instanceof SOAPOperation)) continue;
            soapOperation = (SOAPOperation)element;
        }
        String action = soapOperation.getSoapActionURI();
        String signature = GeneratorHelper.getSignature(m);
        MethodVisitor mv = cw.visitMethod(1025, m.getName(), signature, null, null);
        AnnotationVisitor av = mv.visitAnnotation(GeneratorHelper.getSignature(WebMethod.class), true);
        av.visit("action", (Object)action);
        av.visitEnd();
        PortType portType = definition.getPortType(portTypeName);
        List portTypeOperations = portType.getOperations();
        Operation portTypeOperation = null;
        for (Operation entry : portTypeOperations) {
            if (!entry.getName().equals(m.getName())) continue;
            portTypeOperation = entry;
        }
        av = mv.visitAnnotation(GeneratorHelper.getSignature(WebResult.class), true);
        av.visit("name", (Object)portTypeOperation.getOutput().getMessage().getQName().getLocalPart());
        Collection parts = portTypeOperation.getOutput().getMessage().getParts().values();
        av.visit("partName", (Object)((Part)parts.iterator().next()).getName());
        av.visitEnd();
        av = mv.visitParameterAnnotation(0, GeneratorHelper.getSignature(WebParam.class), true);
        parts = portTypeOperation.getInput().getMessage().getParts().values();
        String partName = ((Part)parts.iterator().next()).getName();
        av.visit("name", (Object)partName);
        av.visit("partName", (Object)partName);
        av.visitEnd();
        mv.visitEnd();
    }
}

