/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.java;

import com.sun.xml.ws.api.BindingID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fabric3.api.binding.ws.model.WsBindingDefinition;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.component.AbstractReference;
import org.fabric3.api.model.type.component.AbstractService;
import org.fabric3.api.model.type.component.BindableDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.definitions.Intent;
import org.fabric3.api.model.type.definitions.PolicySet;
import org.fabric3.binding.ws.metro.generator.GenerationHelper;
import org.fabric3.binding.ws.metro.generator.MetroGeneratorDelegate;
import org.fabric3.binding.ws.metro.generator.PolicyExpressionMapping;
import org.fabric3.binding.ws.metro.generator.WsdlElement;
import org.fabric3.binding.ws.metro.generator.java.EndpointSynthesizer;
import org.fabric3.binding.ws.metro.generator.java.codegen.GeneratedInterface;
import org.fabric3.binding.ws.metro.generator.java.codegen.InterfaceFromWsdlGenerator;
import org.fabric3.binding.ws.metro.generator.java.codegen.InterfaceGenerator;
import org.fabric3.binding.ws.metro.generator.java.wsdl.GeneratedArtifacts;
import org.fabric3.binding.ws.metro.generator.java.wsdl.JavaWsdlGenerator;
import org.fabric3.binding.ws.metro.generator.policy.WsdlPolicyAttacher;
import org.fabric3.binding.ws.metro.generator.resolver.EndpointResolutionException;
import org.fabric3.binding.ws.metro.generator.resolver.EndpointResolver;
import org.fabric3.binding.ws.metro.generator.resolver.TargetUrlResolver;
import org.fabric3.binding.ws.metro.generator.resolver.WsdlResolutionException;
import org.fabric3.binding.ws.metro.generator.resolver.WsdlResolver;
import org.fabric3.binding.ws.metro.generator.validator.WsdlEndpointValidator;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.MetroJavaWireSourceDefinition;
import org.fabric3.binding.ws.metro.provision.MetroJavaWireTargetDefinition;
import org.fabric3.binding.ws.metro.provision.MetroWireTargetDefinition;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.provision.SecurityConfiguration;
import org.fabric3.binding.ws.metro.provision.ServiceEndpointDefinition;
import org.fabric3.binding.ws.metro.util.BindingIdResolver;
import org.fabric3.binding.ws.metro.util.ClassLoaderUpdater;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.policy.EffectivePolicy;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.physical.PhysicalBindingHandlerDefinition;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.wsdl.model.WsdlServiceContract;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class JavaGeneratorDelegate
implements MetroGeneratorDelegate<JavaServiceContract> {
    private static final String REPLACEABLE_ADDRESS = "REPLACE_WITH_ACTUAL_URL";
    private WsdlResolver wsdlResolver;
    private EndpointResolver endpointResolver;
    private EndpointSynthesizer synthesizer;
    private JavaWsdlGenerator wsdlGenerator;
    private InterfaceGenerator interfaceGenerator;
    private InterfaceFromWsdlGenerator interfaceFromWsdlGenerator;
    private BindingIdResolver bindingIdResolver;
    private WsdlPolicyAttacher policyAttacher;
    private ClassLoaderRegistry classLoaderRegistry;
    private ClassLoaderUpdater classLoaderUpdater;
    private TargetUrlResolver targetUrlResolver;
    private WsdlEndpointValidator endpointValidator;
    private HostInfo info;
    private DocumentBuilder documentBuilder;
    private TransformerFactory transformerFactory;

    public JavaGeneratorDelegate(@Reference WsdlResolver wsdlResolver, @Reference EndpointResolver endpointResolver, @Reference EndpointSynthesizer synthesizer, @Reference JavaWsdlGenerator wsdlGenerator, @Reference InterfaceGenerator interfaceGenerator, @Reference InterfaceFromWsdlGenerator interfaceFromWsdlGenerator, @Reference BindingIdResolver bindingIdResolver, @Reference WsdlPolicyAttacher policyAttacher, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference ClassLoaderUpdater classLoaderUpdater, @Reference TargetUrlResolver targetUrlResolver, @Reference WsdlEndpointValidator endpointValidator, @Reference HostInfo info) throws ParserConfigurationException {
        this.wsdlResolver = wsdlResolver;
        this.endpointResolver = endpointResolver;
        this.synthesizer = synthesizer;
        this.wsdlGenerator = wsdlGenerator;
        this.interfaceGenerator = interfaceGenerator;
        this.interfaceFromWsdlGenerator = interfaceFromWsdlGenerator;
        this.bindingIdResolver = bindingIdResolver;
        this.policyAttacher = policyAttacher;
        this.classLoaderRegistry = classLoaderRegistry;
        this.classLoaderUpdater = classLoaderUpdater;
        this.targetUrlResolver = targetUrlResolver;
        this.endpointValidator = endpointValidator;
        this.info = info;
        this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.transformerFactory = TransformerFactory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetroJavaWireSourceDefinition generateSource(LogicalBinding<WsBindingDefinition> binding, JavaServiceContract contract, EffectivePolicy policy) throws GenerationException {
        URI contributionUri = ((LogicalComponent)((Bindable)binding.getParent()).getParent()).getDefinition().getContributionUri();
        Class<?> serviceClass = this.loadServiceClass(contract, contributionUri);
        WsBindingDefinition definition = (WsBindingDefinition)binding.getDefinition();
        URL wsdlLocation = this.getWsdlLocation(definition, serviceClass);
        ServiceEndpointDefinition endpointDefinition = this.createServiceEndpointDefinition(binding, contract, serviceClass, wsdlLocation);
        String interfaze = contract.getQualifiedInterfaceName();
        ArrayList<QName> intentNames = new ArrayList<QName>();
        Set endpointIntents = policy.getProvidedEndpointIntents();
        for (Intent intent : endpointIntents) {
            intentNames.add(intent.getName());
        }
        ArrayList<Element> policyExpressions = new ArrayList<Element>();
        for (PolicySet policySet : policy.getEndpointPolicySets()) {
            Element expression = policySet.getExpression();
            if (expression == null) continue;
            policyExpressions.add(expression);
        }
        List<PolicyExpressionMapping> mappings = GenerationHelper.createMappings(policy, serviceClass);
        List<PhysicalBindingHandlerDefinition> handlers = GenerationHelper.generateBindingHandlers(this.info.getDomain(), definition);
        byte[] generatedBytes = null;
        String wsdl = null;
        Map<String, String> schemas = Collections.emptyMap();
        this.classLoaderUpdater.updateClassLoader(serviceClass);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(serviceClass.getClassLoader());
            if (this.interfaceGenerator.doGeneration(serviceClass)) {
                GeneratedInterface generatedInterface = this.interfaceGenerator.generate(serviceClass, null, null, null, null);
                generatedBytes = generatedInterface.getBytes();
                serviceClass = generatedInterface.getGeneratedClass();
                interfaze = serviceClass.getName();
            }
            if (!policyExpressions.isEmpty() || !mappings.isEmpty()) {
                BindingID bindingId = this.bindingIdResolver.resolveBindingId(intentNames);
                QName name = endpointDefinition.getServiceName();
                GeneratedArtifacts artifacts = this.wsdlGenerator.generate(serviceClass, name, REPLACEABLE_ADDRESS, bindingId);
                wsdl = artifacts.getWsdl();
                schemas = artifacts.getSchemas();
                wsdl = this.mergePolicy(wsdl, policyExpressions, mappings);
            } else if (endpointDefinition.getWsdl() != null) {
                wsdl = endpointDefinition.getWsdl();
            }
            URI classLoaderUri = null;
            if (serviceClass.getClassLoader() instanceof MultiParentClassLoader) {
                classLoaderUri = ((MultiParentClassLoader)serviceClass.getClassLoader()).getName();
            }
            URI serviceUri = null;
            if (binding.isCallback()) {
                LogicalComponent component = (LogicalComponent)((Bindable)binding.getParent()).getParent();
                for (LogicalService service : component.getServices()) {
                    if (!service.getServiceContract().getQualifiedInterfaceName().equals(contract.getQualifiedInterfaceName())) continue;
                    try {
                        serviceUri = new URI(component.getUri() + "#" + service.getDefinition().getName());
                        break;
                    }
                    catch (URISyntaxException e) {
                        throw new GenerationException((Throwable)e);
                    }
                }
            } else {
                serviceUri = ((Bindable)binding.getParent()).getUri();
            }
            boolean bidirectional = contract.getCallbackContract() != null && !binding.isCallback();
            MetroJavaWireSourceDefinition metroJavaWireSourceDefinition = new MetroJavaWireSourceDefinition(serviceUri, endpointDefinition, interfaze, generatedBytes, classLoaderUri, wsdl, schemas, intentNames, wsdlLocation, bidirectional, handlers);
            return metroJavaWireSourceDefinition;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public MetroWireTargetDefinition generateTarget(LogicalBinding<WsBindingDefinition> binding, JavaServiceContract contract, EffectivePolicy policy) throws GenerationException {
        URL targetUrl = null;
        WsBindingDefinition definition = (WsBindingDefinition)binding.getDefinition();
        URI targetUri = definition.getTargetUri();
        if (binding.isCallback() && targetUri != null) {
            throw new GenerationException("A web services callback binding cannot be used with a binding URI on a service: " + ((Bindable)binding.getParent()).getUri());
        }
        if (targetUri != null) {
            if (!targetUri.isAbsolute() && !binding.isCallback()) {
                throw new GenerationException("Web service binding URI must be absolute on reference: " + ((Bindable)binding.getParent()).getUri());
            }
            try {
                targetUrl = targetUri.toURL();
            }
            catch (MalformedURLException e) {
                throw new GenerationException((Throwable)e);
            }
        } else if (definition.getWsdlElement() == null && definition.getWsdlLocation() == null && !binding.isCallback()) {
            throw new GenerationException("A web service binding URI must be specified: " + ((Bindable)binding.getParent()).getUri());
        }
        return this.generateTarget(binding, targetUrl, contract, policy);
    }

    @Override
    public MetroWireTargetDefinition generateServiceBindingTarget(LogicalBinding<WsBindingDefinition> serviceBinding, JavaServiceContract contract, EffectivePolicy policy) throws GenerationException {
        URL targetUrl = this.targetUrlResolver.resolveUrl(serviceBinding, policy);
        return this.generateTarget(serviceBinding, targetUrl, contract, policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetroWireTargetDefinition generateTarget(LogicalBinding<WsBindingDefinition> binding, URL targetUrl, JavaServiceContract contract, EffectivePolicy policy) throws GenerationException {
        URI contributionUri = ((LogicalComponent)((Bindable)binding.getParent()).getParent()).getDefinition().getContributionUri();
        Class<?> serviceClass = this.loadServiceClass(contract, contributionUri);
        WsBindingDefinition definition = (WsBindingDefinition)binding.getDefinition();
        URL wsdlLocation = this.getWsdlLocation(definition, serviceClass);
        ReferenceEndpointDefinition endpointDefinition = this.createReferenceEndpointDefinition(binding, contract, serviceClass, targetUrl, wsdlLocation);
        String interfaze = contract.getQualifiedInterfaceName();
        Set endpointIntents = policy.getProvidedEndpointIntents();
        ArrayList<QName> intentNames = new ArrayList<QName>();
        for (Intent intent : endpointIntents) {
            intentNames.add(intent.getName());
        }
        ArrayList<Element> policyExpressions = new ArrayList<Element>();
        for (PolicySet policySet : policy.getEndpointPolicySets()) {
            Element expression = policySet.getExpression();
            if (expression == null) continue;
            policyExpressions.add(expression);
        }
        List<PolicyExpressionMapping> mappings = GenerationHelper.createMappings(policy, serviceClass);
        List<PhysicalBindingHandlerDefinition> handlers = GenerationHelper.generateBindingHandlers(this.info.getDomain(), definition);
        byte[] generatedBytes = null;
        String wsdl = null;
        Map<String, String> schemas = Collections.emptyMap();
        this.classLoaderUpdater.updateClassLoader(serviceClass);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(serviceClass.getClassLoader());
            if (this.interfaceGenerator.doGeneration(serviceClass)) {
                GeneratedInterface generatedInterface;
                if (endpointDefinition.isRpcLit()) {
                    generatedInterface = this.interfaceFromWsdlGenerator.generateRPCLit(serviceClass, endpointDefinition);
                    generatedBytes = generatedInterface.getBytes();
                    serviceClass = generatedInterface.getGeneratedClass();
                    interfaze = serviceClass.getName();
                } else {
                    generatedInterface = this.interfaceGenerator.generate(serviceClass, null, null, null, null);
                    generatedBytes = generatedInterface.getBytes();
                    serviceClass = generatedInterface.getGeneratedClass();
                    interfaze = serviceClass.getName();
                }
            }
            if (!policyExpressions.isEmpty() || !mappings.isEmpty()) {
                BindingID bindingId = this.bindingIdResolver.resolveBindingId(intentNames);
                QName name = endpointDefinition.getServiceName();
                String address = endpointDefinition.getUrl().toString();
                GeneratedArtifacts artifacts = this.wsdlGenerator.generate(serviceClass, name, address, bindingId);
                wsdl = artifacts.getWsdl();
                schemas = artifacts.getSchemas();
                wsdl = this.mergePolicy(wsdl, policyExpressions, mappings);
            } else if (endpointDefinition.getWsdl() != null) {
                wsdl = endpointDefinition.getWsdl();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        SecurityConfiguration securityConfiguration = GenerationHelper.createSecurityConfiguration(definition);
        ConnectionConfiguration connectionConfiguration = GenerationHelper.createConnectionConfiguration(definition);
        URI classLoaderUri = null;
        if (serviceClass.getClassLoader() instanceof MultiParentClassLoader) {
            classLoaderUri = ((MultiParentClassLoader)serviceClass.getClassLoader()).getName();
        }
        boolean bidirectional = contract.getCallbackContract() != null && !binding.isCallback();
        int retries = definition.getRetries();
        MetroJavaWireTargetDefinition targetDefinition = new MetroJavaWireTargetDefinition(endpointDefinition, interfaze, generatedBytes, classLoaderUri, wsdl, schemas, wsdlLocation, intentNames, securityConfiguration, connectionConfiguration, retries, bidirectional, handlers);
        if (binding.isCallback()) {
            targetDefinition.setUri(((Bindable)binding.getParent()).getUri());
        }
        return targetDefinition;
    }

    private URL getWsdlLocation(WsBindingDefinition definition, Class<?> serviceClass) throws GenerationException {
        try {
            String location = definition.getWsdlLocation();
            if (location != null) {
                return new URL(location);
            }
            WebService annotation = serviceClass.getAnnotation(WebService.class);
            if (annotation != null) {
                String wsdlLocation = annotation.wsdlLocation();
                if (wsdlLocation.length() > 0) {
                    return new URL(wsdlLocation);
                }
                return null;
            }
        }
        catch (MalformedURLException e) {
            throw new GenerationException((Throwable)e);
        }
        return null;
    }

    private Class<?> loadServiceClass(JavaServiceContract javaContract, URI contributionUri) throws GenerationException {
        ClassLoader loader = this.classLoaderRegistry.getClassLoader(contributionUri);
        try {
            return loader.loadClass(javaContract.getInterfaceClass());
        }
        catch (ClassNotFoundException e) {
            throw new GenerationException((Throwable)e);
        }
    }

    private ServiceEndpointDefinition createServiceEndpointDefinition(LogicalBinding<WsBindingDefinition> binding, JavaServiceContract contract, Class<?> serviceClass, URL wsdlLocation) throws GenerationException {
        ServiceEndpointDefinition endpointDefinition;
        URI targetUri = ((WsBindingDefinition)binding.getDefinition()).getTargetUri();
        if (targetUri != null) {
            endpointDefinition = this.synthesizer.synthesizeServiceEndpoint(contract, serviceClass, targetUri);
        } else {
            String wsdlElementString = ((WsBindingDefinition)binding.getDefinition()).getWsdlElement();
            if (wsdlElementString == null) {
                BindableDefinition parent = (BindableDefinition)((WsBindingDefinition)binding.getDefinition()).getParent();
                ServiceContract serviceContract = this.getServiceContract(parent);
                if (serviceContract instanceof WsdlServiceContract) {
                    return this.synthesizeEndpointFromWsdlInterface(binding, (WsdlServiceContract)serviceContract);
                }
                return this.synthesizeEndpointFromClass(binding, contract, serviceClass);
            }
            WsdlElement wsdlElement = GenerationHelper.parseWsdlElement(wsdlElementString);
            if (WsdlElement.Type.SERVICE == wsdlElement.getType()) {
                throw new GenerationException("Services cannot specify a wsdl.service in the web service binding: " + ((Bindable)binding.getParent()).getUri());
            }
            if (wsdlLocation == null) {
                URI contributionUri = ((LogicalComponent)((Bindable)binding.getParent()).getParent()).getDefinition().getContributionUri();
                if (WsdlElement.Type.BINDING == wsdlElement.getType()) {
                    this.endpointValidator.validateBinding(contributionUri, binding, wsdlElement.getBindingName());
                    return this.synthesizeEndpointFromClass(binding, contract, serviceClass);
                }
                Definition wsdl = this.wsdlResolver.resolveWsdlByPortName(contributionUri, wsdlElement.getPortName());
                endpointDefinition = this.endpointResolver.resolveServiceEndpoint(wsdlElement, wsdl);
                this.endpointValidator.validate(contributionUri, binding, endpointDefinition);
            } else {
                Definition wsdl = this.wsdlResolver.parseWsdl(wsdlLocation);
                endpointDefinition = this.endpointResolver.resolveServiceEndpoint(wsdlElement, wsdl);
            }
        }
        return endpointDefinition;
    }

    private ServiceEndpointDefinition synthesizeEndpointFromWsdlInterface(LogicalBinding<WsBindingDefinition> binding, WsdlServiceContract wsdlContract) throws EndpointResolutionException {
        Definition wsdl = wsdlContract.getDefinition();
        QName portType = wsdlContract.getPortType().getQName();
        QName serviceName = new QName(portType.getNamespaceURI(), portType.getLocalPart() + "Service");
        QName portName = new QName(portType.getNamespaceURI(), portType.getLocalPart() + "Port");
        Bindable service = (Bindable)binding.getParent();
        URI targetUri = URI.create(service.getUri().getFragment());
        String serializedWsdl = this.endpointResolver.serializeWsdl(wsdl);
        return new ServiceEndpointDefinition(serviceName, portName, targetUri, serializedWsdl);
    }

    private ServiceEndpointDefinition synthesizeEndpointFromClass(LogicalBinding<WsBindingDefinition> binding, JavaServiceContract contract, Class<?> serviceClass) throws GenerationException {
        Bindable service = (Bindable)binding.getParent();
        for (LogicalBinding otherBinding : service.getBindings()) {
            WsBindingDefinition wsDefinition;
            if (binding == otherBinding || !WsBindingDefinition.BINDING_QNAME.equals(otherBinding.getDefinition().getType()) || (wsDefinition = (WsBindingDefinition)otherBinding.getDefinition()).getTargetUri() != null || wsDefinition.getWsdlElement() != null) continue;
            throw new GenerationException("If there is more than one web service binding, one must provide a URI or WSDLElement:" + service.getUri());
        }
        URI targetUri = URI.create(service.getUri().getFragment());
        return this.synthesizer.synthesizeServiceEndpoint(contract, serviceClass, targetUri);
    }

    private String mergePolicy(String wsdl, List<Element> policyExpressions, List<PolicyExpressionMapping> mappings) throws GenerationException {
        try {
            Document wsdlDocument = this.documentBuilder.parse(new ByteArrayInputStream(wsdl.getBytes()));
            this.policyAttacher.attach(wsdlDocument, policyExpressions, mappings);
            DOMSource source = new DOMSource(wsdlDocument);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (IOException | TransformerException | SAXException e) {
            throw new GenerationException((Throwable)e);
        }
    }

    private ReferenceEndpointDefinition createReferenceEndpointDefinition(LogicalBinding<WsBindingDefinition> binding, JavaServiceContract contract, Class<?> serviceClass, URL targetUrl, URL wsdlLocation) throws GenerationException {
        ReferenceEndpointDefinition endpointDefinition;
        WsBindingDefinition definition = (WsBindingDefinition)binding.getDefinition();
        URI contributionUri = this.getContributionUri(binding);
        boolean rpcLit = false;
        Definition wsdl = null;
        if (binding.isCallback()) {
            targetUrl = ReferenceEndpointDefinition.DYNAMIC_URL;
        }
        if (targetUrl != null) {
            if (definition.getWsdlElement() != null) {
                WsdlElement wsdlElement = GenerationHelper.parseWsdlElement(definition.getWsdlElement());
                if (WsdlElement.Type.BINDING != wsdlElement.getType()) {
                    throw new GenerationException("Cannot specify a target URI and non-binding wsdlElement: " + ((Bindable)binding.getParent()).getUri());
                }
                QName bindingName = wsdlElement.getBindingName();
                wsdl = this.resolveWsdl(wsdlLocation, contributionUri, bindingName);
                Binding wsdlBinding = wsdl.getBinding(bindingName);
                for (Object element : wsdlBinding.getExtensibilityElements()) {
                    if (!(element instanceof SOAPBinding)) continue;
                    rpcLit = "rpc".equalsIgnoreCase(((SOAPBinding)element).getStyle());
                    break;
                }
                List operations = wsdlBinding.getBindingOperations();
                for (BindingOperation operation : operations) {
                    BindingInput input = operation.getBindingInput();
                    for (Object element : input.getExtensibilityElements()) {
                        SOAPBody body;
                        if (!(element instanceof SOAPBody) || !"encoded".equals((body = (SOAPBody)element).getUse())) continue;
                        throw new GenerationException("RPC encoded not supported: " + ((Bindable)binding.getParent()).getUri());
                    }
                }
                QName portTypeName = wsdlBinding.getPortType().getQName();
                endpointDefinition = this.synthesizer.synthesizeReferenceEndpoint(contract, serviceClass, portTypeName, targetUrl);
                this.endpointValidator.validateBinding(contributionUri, binding, bindingName);
            } else {
                endpointDefinition = this.synthesizer.synthesizeReferenceEndpoint(contract, serviceClass, targetUrl);
            }
        } else {
            WsdlElement wsdlElement = GenerationHelper.parseWsdlElement(definition.getWsdlElement());
            if (wsdlLocation == null) {
                wsdl = this.resolveWsdl(contributionUri, wsdlElement);
                endpointDefinition = this.endpointResolver.resolveReferenceEndpoint(wsdlElement, wsdl);
                this.endpointValidator.validate(contributionUri, binding, endpointDefinition);
            } else {
                wsdl = this.wsdlResolver.parseWsdl(wsdlLocation);
                endpointDefinition = this.endpointResolver.resolveReferenceEndpoint(wsdlElement, wsdl);
            }
        }
        endpointDefinition.setRpcLit(rpcLit);
        endpointDefinition.setDefinition(wsdl);
        return endpointDefinition;
    }

    private Definition resolveWsdl(URI contributionUri, WsdlElement wsdlElement) throws WsdlResolutionException {
        Definition wsdl = WsdlElement.Type.PORT == wsdlElement.getType() ? this.wsdlResolver.resolveWsdlByPortName(contributionUri, wsdlElement.getPortName()) : (WsdlElement.Type.SERVICE == wsdlElement.getType() ? this.wsdlResolver.resolveWsdlByServiceName(contributionUri, wsdlElement.getServiceName()) : this.wsdlResolver.resolveWsdlByBindingName(contributionUri, wsdlElement.getBindingName()));
        return wsdl;
    }

    private Definition resolveWsdl(URL wsdlLocation, URI contributionUri, QName bindingName) throws WsdlResolutionException {
        Definition wsdl = wsdlLocation != null ? this.wsdlResolver.parseWsdl(wsdlLocation) : this.wsdlResolver.resolveWsdlByBindingName(contributionUri, bindingName);
        return wsdl;
    }

    private URI getContributionUri(LogicalBinding<WsBindingDefinition> binding) {
        LogicalComponent current = (LogicalComponent)((Bindable)binding.getParent()).getParent();
        while (((LogicalCompositeComponent)current.getParent()).getParent() != null) {
            current = (LogicalComponent)current.getParent();
        }
        return current.getDefinition().getContributionUri();
    }

    private ServiceContract getServiceContract(BindableDefinition parent) throws GenerationException {
        ServiceContract serviceContract;
        if (parent instanceof AbstractService) {
            serviceContract = ((AbstractService)parent).getServiceContract();
        } else if (parent instanceof AbstractReference) {
            serviceContract = ((AbstractReference)parent).getServiceContract();
        } else {
            throw new GenerationException("Unsupported bindable type: " + parent);
        }
        return serviceContract;
    }
}

