/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator;

import java.util.List;
import java.util.Map;
import org.fabric3.api.binding.ws.model.WsBindingDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.binding.ws.metro.generator.MetroGeneratorDelegate;
import org.fabric3.binding.ws.metro.provision.MetroWireSourceDefinition;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.policy.EffectivePolicy;
import org.fabric3.spi.domain.generator.wire.WireBindingGenerator;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.oasisopen.sca.annotation.Reference;

public class MetroWireBindingGenerator
implements WireBindingGenerator<WsBindingDefinition> {
    private Map<Class<?>, MetroGeneratorDelegate> delegates;

    @Reference
    public void setDelegates(Map<Class<?>, MetroGeneratorDelegate> delegates) {
        this.delegates = delegates;
    }

    public MetroWireSourceDefinition generateSource(LogicalBinding<WsBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        MetroGeneratorDelegate delegate = this.getDelegate(contract);
        return delegate.generateSource(binding, contract, policy);
    }

    public PhysicalWireTargetDefinition generateTarget(LogicalBinding<WsBindingDefinition> binding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        MetroGeneratorDelegate delegate = this.getDelegate(contract);
        return delegate.generateTarget(binding, contract, policy);
    }

    public PhysicalWireTargetDefinition generateServiceBindingTarget(LogicalBinding<WsBindingDefinition> serviceBinding, ServiceContract contract, List<LogicalOperation> operations, EffectivePolicy policy) throws GenerationException {
        MetroGeneratorDelegate delegate = this.getDelegate(contract);
        return delegate.generateServiceBindingTarget(serviceBinding, contract, policy);
    }

    private MetroGeneratorDelegate getDelegate(ServiceContract contract) throws GenerationException {
        MetroGeneratorDelegate delegate = this.delegates.get(contract.getClass());
        if (delegate == null) {
            throw new GenerationException("Generator delegate not found for type: " + contract.getClass().getName());
        }
        return delegate;
    }
}

