/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.xml.namespace.QName;
import org.fabric3.api.binding.ws.model.WsBindingDefinition;
import org.fabric3.api.model.type.component.BindingHandlerDefinition;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.api.model.type.definitions.PolicySet;
import org.fabric3.binding.ws.metro.generator.InvalidConfigurationException;
import org.fabric3.binding.ws.metro.generator.PolicyExpressionMapping;
import org.fabric3.binding.ws.metro.generator.WsdlElement;
import org.fabric3.binding.ws.metro.generator.WsdlElementParseException;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.SecurityConfiguration;
import org.fabric3.spi.domain.generator.GenerationException;
import org.fabric3.spi.domain.generator.policy.EffectivePolicy;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.physical.PhysicalBindingHandlerDefinition;
import org.fabric3.spi.util.UriHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GenerationHelper {
    private static final String WS_SECURITY_UTILITY_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";

    private GenerationHelper() {
    }

    public static WsdlElement parseWsdlElement(String wsdlElement) throws WsdlElementParseException {
        URI uri;
        if (wsdlElement == null) {
            throw new IllegalArgumentException("Null wsdlElement");
        }
        try {
            uri = new URI(wsdlElement);
        }
        catch (URISyntaxException e) {
            throw new WsdlElementParseException(e);
        }
        String namespace = UriHelper.getDefragmentedNameAsString((URI)uri);
        String fragment = uri.getFragment();
        if (fragment != null && fragment.startsWith("wsdl.port(")) {
            String name = fragment.substring(10, fragment.length() - 1);
            String[] tokens = name.split("/");
            if (tokens.length != 2) {
                throw new WsdlElementParseException("Invalid wsdlElement expression: " + fragment);
            }
            QName serviceName = new QName(namespace, tokens[0]);
            QName portName = new QName(namespace, tokens[1]);
            return new WsdlElement(serviceName, portName);
        }
        if (fragment != null && fragment.startsWith("wsdl.service(")) {
            String name = fragment.substring(13, fragment.length() - 1);
            QName serviceName = new QName(namespace, name);
            return new WsdlElement(serviceName, WsdlElement.Type.SERVICE);
        }
        if (fragment != null && fragment.startsWith("wsdl.binding(")) {
            String name = fragment.substring(13, fragment.length() - 1);
            QName bindingName = new QName(namespace, name);
            return new WsdlElement(bindingName, WsdlElement.Type.BINDING);
        }
        throw new WsdlElementParseException("Expression not supported: " + fragment);
    }

    public static List<PolicyExpressionMapping> createMappings(EffectivePolicy policy) throws GenerationException {
        return GenerationHelper.createMappings(policy, null);
    }

    public static List<PolicyExpressionMapping> createMappings(EffectivePolicy policy, Class<?> serviceClass) throws GenerationException {
        HashMap<String, PolicyExpressionMapping> mappings = new HashMap<String, PolicyExpressionMapping>();
        for (Map.Entry entry : policy.getOperationPolicySets().entrySet()) {
            Operation definition = ((LogicalOperation)entry.getKey()).getDefinition();
            for (PolicySet policySet : (List)entry.getValue()) {
                Element expression = policySet.getExpression();
                if (expression == null) continue;
                Node node = expression.getAttributes().getNamedItemNS(WS_SECURITY_UTILITY_NS, "Id");
                if (node == null) {
                    URI uri = policySet.getContributionUri();
                    QName expressionName = policySet.getExpressionName();
                    throw new GenerationException("Invalid policy in contribution " + uri + ". No id specified: " + expressionName);
                }
                String id = node.getNodeValue();
                PolicyExpressionMapping mapping = (PolicyExpressionMapping)mappings.get(id);
                if (mapping == null) {
                    mapping = new PolicyExpressionMapping(id, expression);
                    mappings.put(id, mapping);
                }
                String operationName = serviceClass == null ? GenerationHelper.getWsdlName(definition, serviceClass) : definition.getName();
                mapping.addOperationName(operationName);
            }
        }
        return new ArrayList<PolicyExpressionMapping>(mappings.values());
    }

    public static SecurityConfiguration createSecurityConfiguration(WsBindingDefinition definition) {
        SecurityConfiguration configuration = null;
        Map configProperties = definition.getConfiguration();
        if (configProperties != null) {
            String alias = (String)configProperties.get("alias");
            if (alias != null) {
                configuration = new SecurityConfiguration(alias);
            } else {
                String username = (String)configProperties.get("username");
                String password = (String)configProperties.get("password");
                configuration = new SecurityConfiguration(username, password);
            }
        }
        return configuration;
    }

    public static ConnectionConfiguration createConnectionConfiguration(WsBindingDefinition definition) throws InvalidConfigurationException {
        ConnectionConfiguration configuration = new ConnectionConfiguration();
        Map configProperties = definition.getConfiguration();
        if (configProperties != null) {
            String clientStreamingChunkSize;
            String requestTimeout;
            String connectTimeout = (String)configProperties.get("connectTimeout");
            if (connectTimeout != null) {
                try {
                    configuration.setConnectTimeout(Integer.parseInt(connectTimeout));
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("Invalid connectTimeout", e);
                }
            }
            if ((requestTimeout = (String)configProperties.get("requestTimeout")) != null) {
                try {
                    configuration.setRequestTimeout(Integer.parseInt(requestTimeout));
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("Invalid requestTimeout", e);
                }
            }
            if ((clientStreamingChunkSize = (String)configProperties.get("clientStreamingChunkSize")) != null) {
                try {
                    configuration.setClientStreamingChunkSize(Integer.parseInt(clientStreamingChunkSize));
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("Invalid clientStreamingChunkSize", e);
                }
            }
        }
        return configuration;
    }

    public static List<PhysicalBindingHandlerDefinition> generateBindingHandlers(URI domainUri, WsBindingDefinition definition) {
        ArrayList<PhysicalBindingHandlerDefinition> handlers = new ArrayList<PhysicalBindingHandlerDefinition>();
        for (BindingHandlerDefinition handlerDefinition : definition.getHandlers()) {
            URI resolvedUri = URI.create(domainUri.toString() + "/" + handlerDefinition.getTarget());
            handlers.add(new PhysicalBindingHandlerDefinition(resolvedUri));
        }
        return handlers;
    }

    private static String getWsdlName(Operation operation, Class<?> serviceClass) {
        Method method = GenerationHelper.findMethod(operation, serviceClass);
        WebMethod annotation = method.getAnnotation(WebMethod.class);
        if (annotation == null || annotation.operationName().length() < 1) {
            return operation.getName();
        }
        return annotation.operationName();
    }

    private static Method findMethod(Operation operation, Class<?> serviceClass) {
        List types = operation.getInputTypes();
        Class[] params = new Class[types.size()];
        for (int i = 0; i < types.size(); ++i) {
            DataType type = (DataType)types.get(i);
            params[i] = type.getType();
        }
        try {
            return serviceClass.getMethod(operation.getName(), params);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

