/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.async.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.fabric3.api.SecuritySubject;
import org.fabric3.async.runtime.AsyncRequest;
import org.fabric3.async.runtime.NonBlockingMonitor;
import org.fabric3.spi.container.invocation.CallbackReference;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.wire.Interceptor;

public class NonBlockingInterceptor
implements Interceptor {
    private static final Message RESPONSE = new ImmutableMessage();
    private final ExecutorService executorService;
    private NonBlockingMonitor monitor;
    private Interceptor next;

    public NonBlockingInterceptor(ExecutorService executorService, NonBlockingMonitor monitor) {
        this.executorService = executorService;
        this.monitor = monitor;
    }

    public Message invoke(Message msg) {
        WorkContext workContext = msg.getWorkContext();
        ArrayList<CallbackReference> newStack = null;
        List stack = workContext.getCallbackReferences();
        if (stack != null && !stack.isEmpty()) {
            newStack = new ArrayList<CallbackReference>(stack);
        }
        HashMap<String, Object> newHeaders = null;
        Map headers = workContext.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            newHeaders = new HashMap<String, Object>(headers);
        }
        SecuritySubject subject = workContext.getSubject();
        Object payload = msg.getBody();
        AsyncRequest request = new AsyncRequest(this.next, payload, subject, newStack, newHeaders, this.monitor);
        this.executorService.execute(request);
        return RESPONSE;
    }

    public Interceptor getNext() {
        return this.next;
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }

    private static class ImmutableMessage
    implements Message {
        private ImmutableMessage() {
        }

        public Object getBody() {
            return null;
        }

        public void setBody(Object body) {
            if (body != null) {
                throw new UnsupportedOperationException();
            }
        }

        public WorkContext getWorkContext() {
            throw new UnsupportedOperationException();
        }

        public void setWorkContext(WorkContext workContext) {
            throw new UnsupportedOperationException();
        }

        public void reset() {
        }

        public boolean isFault() {
            return false;
        }

        public void setBodyWithFault(Object fault) {
            throw new UnsupportedOperationException();
        }
    }
}

