/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.async.runtime;

import java.util.List;
import java.util.Map;
import org.fabric3.api.SecuritySubject;
import org.fabric3.async.runtime.NonBlockingMonitor;
import org.fabric3.spi.container.invocation.CallbackReference;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageCache;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.container.wire.Interceptor;

public class AsyncRequest
implements Runnable {
    private Interceptor next;
    private Object payload;
    private SecuritySubject subject;
    private List<CallbackReference> stack;
    private Map<String, Object> headers;
    private NonBlockingMonitor monitor;

    public AsyncRequest(Interceptor next, Object payload, SecuritySubject subject, List<CallbackReference> stack, Map<String, Object> headers, NonBlockingMonitor monitor) {
        this.next = next;
        this.payload = payload;
        this.subject = subject;
        this.stack = stack;
        this.headers = headers;
        this.monitor = monitor;
    }

    @Override
    public void run() {
        WorkContext workContext = WorkContextCache.getAndResetThreadWorkContext();
        workContext.addCallbackReferences(this.stack);
        workContext.addHeaders(this.headers);
        workContext.setSubject(this.subject);
        Message message = MessageCache.getAndResetMessage();
        message.setBody(this.payload);
        message.setWorkContext(workContext);
        Message response = this.next.invoke(message);
        if (response.isFault()) {
            this.monitor.onError((Throwable)response.getBody());
        }
        message.reset();
        workContext.reset();
    }

    public Interceptor getNext() {
        return this.next;
    }
}

