/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.reflection.jdk;

import java.lang.reflect.Field;
import org.fabric3.implementation.pojo.objectfactory.MultiplicityObjectFactory;
import org.fabric3.spi.container.objectfactory.InjectionAttributes;
import org.fabric3.spi.container.objectfactory.Injector;
import org.fabric3.spi.container.objectfactory.ObjectCreationException;
import org.fabric3.spi.container.objectfactory.ObjectFactory;

public class FieldInjector
implements Injector<Object> {
    private final Field field;
    private ObjectFactory<?> objectFactory;

    public FieldInjector(Field field, ObjectFactory<?> objectFactory) {
        this.field = field;
        this.field.setAccessible(true);
        this.objectFactory = objectFactory;
    }

    public void inject(Object instance) throws ObjectCreationException {
        try {
            Object target;
            if (this.objectFactory == null) {
                target = null;
            } else {
                target = this.objectFactory.getInstance();
                if (target == null) {
                    return;
                }
            }
            this.field.set(instance, target);
        }
        catch (IllegalAccessException e) {
            String id = this.field.getName();
            throw new AssertionError((Object)("Field is not accessible:" + id));
        }
    }

    public void setObjectFactory(ObjectFactory<?> objectFactory, InjectionAttributes attributes) {
        if (this.objectFactory instanceof MultiplicityObjectFactory) {
            ((MultiplicityObjectFactory)this.objectFactory).addObjectFactory(objectFactory, attributes);
        } else {
            this.objectFactory = objectFactory;
        }
    }

    public void clearObjectFactory() {
        if (this.objectFactory instanceof MultiplicityObjectFactory) {
            ((MultiplicityObjectFactory)this.objectFactory).clear();
        } else {
            this.objectFactory = null;
        }
    }
}

