/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.singleton;

import java.net.URI;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.implementation.system.singleton.SingletonComponent;
import org.fabric3.implementation.system.singleton.SingletonWireSourceDefinition;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.SourceWireAttacher;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.objectfactory.InjectionAttributes;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SingletonSourceWireAttacher
implements SourceWireAttacher<SingletonWireSourceDefinition> {
    private ComponentManager manager;

    public SingletonSourceWireAttacher(@Reference ComponentManager manager) {
        this.manager = manager;
    }

    public void attach(SingletonWireSourceDefinition source, PhysicalWireTargetDefinition target, Wire wire) throws ContainerException {
        throw new UnsupportedOperationException();
    }

    public void detach(SingletonWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
    }

    public void detachObjectFactory(SingletonWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        SingletonComponent component = (SingletonComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeObjectFactory(injectable);
    }

    public void attachObjectFactory(SingletonWireSourceDefinition source, ObjectFactory<?> objectFactory, PhysicalWireTargetDefinition target) throws ContainerException {
        URI sourceId = UriHelper.getDefragmentedName((URI)source.getUri());
        SingletonComponent sourceComponent = (SingletonComponent)this.manager.getComponent(sourceId);
        Injectable injectable = source.getInjectable();
        String key = source.getKey();
        int order = source.getOrder();
        InjectionAttributes attributes = new InjectionAttributes((Object)key, order);
        sourceComponent.addObjectFactory(injectable, objectFactory, attributes);
    }
}

