/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.singleton;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.implementation.pojo.objectfactory.ArrayMultiplicityObjectFactory;
import org.fabric3.implementation.pojo.objectfactory.ListMultiplicityObjectFactory;
import org.fabric3.implementation.pojo.objectfactory.MapMultiplicityObjectFactory;
import org.fabric3.implementation.pojo.objectfactory.MultiplicityObjectFactory;
import org.fabric3.implementation.pojo.objectfactory.SetMultiplicityObjectFactory;
import org.fabric3.spi.container.component.InstanceDestructionException;
import org.fabric3.spi.container.component.InstanceInitException;
import org.fabric3.spi.container.component.InstanceLifecycleException;
import org.fabric3.spi.container.component.ScopedComponent;
import org.fabric3.spi.container.objectfactory.InjectionAttributes;
import org.fabric3.spi.container.objectfactory.ObjectCreationException;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.objectfactory.SingletonObjectFactory;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;

public class SingletonComponent
implements ScopedComponent {
    private final URI uri;
    private Object instance;
    private Map<Member, Injectable> sites;
    private Map<ObjectFactory, Injectable> reinjectionMappings;
    private URI classLoaderId;
    private MonitorLevel level = MonitorLevel.INFO;
    private AtomicBoolean started = new AtomicBoolean(false);

    public SingletonComponent(URI componentId, Object instance, Map<InjectionSite, Injectable> mappings) {
        this.uri = componentId;
        this.instance = instance;
        this.reinjectionMappings = new HashMap<ObjectFactory, Injectable>();
        this.initializeInjectionSites(instance, mappings);
    }

    public URI getClassLoaderId() {
        return this.classLoaderId;
    }

    public void setClassLoaderId(URI classLoaderId) {
        this.classLoaderId = classLoaderId;
    }

    public String getKey() {
        return null;
    }

    public URI getUri() {
        return this.uri;
    }

    public void start() {
        this.started.set(true);
    }

    public void stop() {
        this.started.set(false);
    }

    public void startUpdate() {
        for (ObjectFactory factory : this.reinjectionMappings.keySet()) {
            if (!(factory instanceof MultiplicityObjectFactory)) continue;
            ((MultiplicityObjectFactory)factory).startUpdate();
        }
    }

    public void endUpdate() {
        for (ObjectFactory factory : this.reinjectionMappings.keySet()) {
            if (!(factory instanceof MultiplicityObjectFactory)) continue;
            ((MultiplicityObjectFactory)factory).endUpdate();
        }
    }

    public QName getDeployable() {
        return null;
    }

    public boolean isEagerInit() {
        return true;
    }

    public Object createInstance() throws ObjectCreationException {
        return this.instance;
    }

    public void releaseInstance(Object instance) {
    }

    public ObjectFactory<Object> createObjectFactory() {
        return new SingletonObjectFactory(this.instance);
    }

    public Object getInstance() {
        return this.instance;
    }

    public String getName() {
        return this.uri.toString();
    }

    public MonitorLevel getLevel() {
        return this.level;
    }

    public void setLevel(MonitorLevel level) {
        this.level = level;
    }

    public void startInstance(Object instance) throws InstanceInitException {
    }

    public void stopInstance(Object instance) throws InstanceDestructionException {
    }

    public void reinject(Object instance) throws InstanceLifecycleException {
        for (Map.Entry<ObjectFactory, Injectable> entry : this.reinjectionMappings.entrySet()) {
            try {
                this.inject(entry.getValue(), entry.getKey());
            }
            catch (ObjectCreationException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.reinjectionMappings.clear();
    }

    public void addObjectFactory(Injectable injectable, ObjectFactory objectFactory, InjectionAttributes attributes) {
        if (InjectableType.REFERENCE == injectable.getType()) {
            this.setFactory(injectable, objectFactory, attributes);
        } else {
            this.reinjectionMappings.put(objectFactory, injectable);
        }
    }

    public void removeObjectFactory(Injectable injectable) {
        Iterator<Map.Entry<ObjectFactory, Injectable>> iterator = this.reinjectionMappings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ObjectFactory, Injectable> entry = iterator.next();
            if (!injectable.equals((Object)entry.getValue())) continue;
            iterator.remove();
            break;
        }
    }

    public String toString() {
        return "[" + this.uri.toString() + "] in state [" + super.toString() + ']';
    }

    private void initializeInjectionSites(Object instance, Map<InjectionSite, Injectable> mappings) {
        this.sites = new HashMap<Member, Injectable>();
        for (Map.Entry<InjectionSite, Injectable> entry : mappings.entrySet()) {
            InjectionSite site = entry.getKey();
            if (site instanceof FieldInjectionSite) {
                try {
                    Field field = this.getField(((FieldInjectionSite)site).getName());
                    this.sites.put(field, entry.getValue());
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (!(site instanceof MethodInjectionSite)) continue;
            MethodInjectionSite methodInjectionSite = (MethodInjectionSite)site;
            try {
                Method method = methodInjectionSite.getSignature().getMethod(instance.getClass());
                this.sites.put(method, entry.getValue());
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private void setFactory(Injectable injectable, ObjectFactory objectFactory, InjectionAttributes attributes) {
        ObjectFactory<?> factory = this.findFactory(injectable);
        if (factory == null) {
            Class<?> type = this.getMemberType(injectable);
            if (Map.class.equals(type)) {
                MapMultiplicityObjectFactory mapFactory = new MapMultiplicityObjectFactory();
                mapFactory.startUpdate();
                mapFactory.addObjectFactory(objectFactory, attributes);
                this.reinjectionMappings.put((ObjectFactory)mapFactory, injectable);
            } else if (Set.class.equals(type)) {
                SetMultiplicityObjectFactory setFactory = new SetMultiplicityObjectFactory();
                setFactory.startUpdate();
                setFactory.addObjectFactory(objectFactory, attributes);
                this.reinjectionMappings.put((ObjectFactory)setFactory, injectable);
            } else if (List.class.equals(type)) {
                ListMultiplicityObjectFactory listFactory = new ListMultiplicityObjectFactory();
                listFactory.startUpdate();
                listFactory.addObjectFactory(objectFactory, attributes);
                this.reinjectionMappings.put((ObjectFactory)listFactory, injectable);
            } else if (Collection.class.equals(type)) {
                ListMultiplicityObjectFactory listFactory = new ListMultiplicityObjectFactory();
                listFactory.startUpdate();
                listFactory.addObjectFactory(objectFactory, attributes);
                this.reinjectionMappings.put((ObjectFactory)listFactory, injectable);
            } else if (type.isArray()) {
                ArrayMultiplicityObjectFactory arrayFactory = new ArrayMultiplicityObjectFactory(type.getComponentType());
                arrayFactory.startUpdate();
                arrayFactory.addObjectFactory(objectFactory, attributes);
                this.reinjectionMappings.put((ObjectFactory)arrayFactory, injectable);
            } else {
                this.reinjectionMappings.put(objectFactory, injectable);
            }
        } else if (factory instanceof MultiplicityObjectFactory) {
            MultiplicityObjectFactory multiplicityObjectFactory = (MultiplicityObjectFactory)factory;
            multiplicityObjectFactory.addObjectFactory(objectFactory, attributes);
        } else {
            this.reinjectionMappings.put(objectFactory, injectable);
        }
    }

    private ObjectFactory<?> findFactory(Injectable injectable) {
        ObjectFactory factory = null;
        for (Map.Entry<ObjectFactory, Injectable> entry : this.reinjectionMappings.entrySet()) {
            if (!injectable.equals((Object)entry.getValue())) continue;
            factory = entry.getKey();
            break;
        }
        return factory;
    }

    private Class<?> getMemberType(Injectable injectable) {
        for (Map.Entry<Member, Injectable> entry : this.sites.entrySet()) {
            if (!injectable.equals((Object)entry.getValue())) continue;
            Member member = entry.getKey();
            if (member instanceof Method) {
                return ((Method)member).getParameterTypes()[0];
            }
            if (member instanceof Field) {
                return ((Field)member).getType();
            }
            throw new AssertionError((Object)"Unsupported injection site type for singleton components");
        }
        return null;
    }

    private Field getField(String name) throws NoSuchFieldException {
        for (Class<?> clazz = this.instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(name);
    }

    private void inject(Injectable attribute, ObjectFactory factory) throws ObjectCreationException {
        for (Map.Entry<Member, Injectable> entry : this.sites.entrySet()) {
            Object param;
            if (!entry.getValue().equals((Object)attribute)) continue;
            Member member = entry.getKey();
            if (member instanceof Field) {
                try {
                    param = factory.getInstance();
                    ((Field)member).set(this.instance, param);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new ObjectCreationException((Throwable)e);
                }
            }
            if (member instanceof Method) {
                try {
                    param = factory.getInstance();
                    Method method = (Method)member;
                    method.invoke(this.instance, param);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new ObjectCreationException((Throwable)e);
                }
            }
            throw new ObjectCreationException("Unsupported member type" + member);
        }
    }
}

