/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import org.fabric3.implementation.system.provision.SystemWireTargetDefinition;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.implementation.system.runtime.SystemInvokerInterceptor;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.TargetWireAttacher;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SystemTargetWireAttacher
implements TargetWireAttacher<SystemWireTargetDefinition> {
    private final ComponentManager manager;
    private final ClassLoaderRegistry classLoaderRegistry;

    public SystemTargetWireAttacher(@Reference ComponentManager manager, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.manager = manager;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(PhysicalWireSourceDefinition source, SystemWireTargetDefinition target, Wire wire) throws ContainerException {
        URI targetId = UriHelper.getDefragmentedName((URI)target.getUri());
        SystemComponent targetComponent = (SystemComponent)this.manager.getComponent(targetId);
        Class implementationClass = targetComponent.getImplementationClass();
        ClassLoader loader = implementationClass.getClassLoader();
        for (InvocationChain chain : wire.getInvocationChains()) {
            Method method;
            PhysicalOperationDefinition operation = chain.getPhysicalOperation();
            List params = operation.getSourceParameterTypes();
            Class[] paramTypes = new Class[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                String param = (String)params.get(i);
                try {
                    paramTypes[i] = this.classLoaderRegistry.loadClass(loader, param);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new ContainerException("Implementation class not found", (Throwable)e);
                }
            }
            try {
                method = implementationClass.getMethod(operation.getName(), paramTypes);
            }
            catch (NoSuchMethodException e) {
                throw new ContainerException("No matching method found", (Throwable)e);
            }
            SystemInvokerInterceptor interceptor = new SystemInvokerInterceptor(method, (AtomicComponent)targetComponent);
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    public void detach(PhysicalWireSourceDefinition source, SystemWireTargetDefinition target) throws ContainerException {
        throw new AssertionError();
    }

    public ObjectFactory<?> createObjectFactory(SystemWireTargetDefinition target) throws ContainerException {
        URI targetId = UriHelper.getDefragmentedName((URI)target.getUri());
        SystemComponent targetComponent = (SystemComponent)this.manager.getComponent(targetId);
        return targetComponent.createObjectFactory();
    }
}

