/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.lang.reflect.Method;
import java.net.URI;
import org.fabric3.api.model.type.java.Signature;
import org.fabric3.implementation.pojo.component.InvokerEventStreamHandler;
import org.fabric3.implementation.pojo.spi.reflection.ConsumerInvoker;
import org.fabric3.implementation.pojo.spi.reflection.ReflectionFactory;
import org.fabric3.implementation.system.provision.SystemConnectionTargetDefinition;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.TargetConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.EventStream;
import org.fabric3.spi.container.channel.EventStreamHandler;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SystemTargetConnectionAttacher
implements TargetConnectionAttacher<SystemConnectionTargetDefinition> {
    private ComponentManager manager;
    private ReflectionFactory reflectionFactory;
    private ClassLoaderRegistry classLoaderRegistry;

    public SystemTargetConnectionAttacher(@Reference ComponentManager manager, @Reference ReflectionFactory reflectionFactory, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.manager = manager;
        this.reflectionFactory = reflectionFactory;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(PhysicalConnectionSourceDefinition source, SystemConnectionTargetDefinition target, ChannelConnection connection) throws ContainerException {
        URI targetUri = target.getUri();
        URI targetName = UriHelper.getDefragmentedName((URI)targetUri);
        SystemComponent component = (SystemComponent)this.manager.getComponent(targetName);
        if (component == null) {
            throw new ContainerException("Target component not found: " + targetName);
        }
        ClassLoader loader = this.classLoaderRegistry.getClassLoader(target.getClassLoaderId());
        Method method = this.loadMethod(target, component);
        ConsumerInvoker invoker = this.reflectionFactory.createConsumerInvoker(method);
        InvokerEventStreamHandler handler = new InvokerEventStreamHandler(invoker, (AtomicComponent)component, loader);
        EventStream stream = connection.getEventStream();
        stream.addHandler((EventStreamHandler)handler);
    }

    public void detach(PhysicalConnectionSourceDefinition source, SystemConnectionTargetDefinition target) throws ContainerException {
    }

    private Method loadMethod(SystemConnectionTargetDefinition target, SystemComponent component) throws ContainerException {
        Signature signature = target.getConsumerSignature();
        Class implementationClass = component.getImplementationClass();
        try {
            return signature.getMethod(implementationClass);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new ContainerException((Throwable)e);
        }
    }
}

