/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.net.URI;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.implementation.pojo.builder.PojoSourceWireAttacher;
import org.fabric3.implementation.pojo.spi.proxy.WireProxyService;
import org.fabric3.implementation.system.provision.SystemWireSourceDefinition;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.SourceWireAttacher;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.objectfactory.InjectionAttributes;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.fabric3.spi.transform.TransformerRegistry;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SystemSourceWireAttacher
extends PojoSourceWireAttacher
implements SourceWireAttacher<SystemWireSourceDefinition> {
    private final ComponentManager manager;
    private WireProxyService proxyService;

    public SystemSourceWireAttacher(@Reference ComponentManager manager, @Reference TransformerRegistry transformerRegistry, @Reference ClassLoaderRegistry classLoaderRegistry) {
        super(transformerRegistry, classLoaderRegistry);
        this.manager = manager;
    }

    @Reference(required=false)
    public void setProxyService(WireProxyService proxyService) {
        this.proxyService = proxyService;
    }

    public void attach(SystemWireSourceDefinition source, PhysicalWireTargetDefinition target, Wire wire) throws ContainerException {
        Class type;
        if (this.proxyService == null) {
            throw new ContainerException("Attempt to inject a non-optimized wire during runtime bootstrap.");
        }
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        try {
            type = this.classLoaderRegistry.loadClass(source.getClassLoaderId(), source.getInterfaceName());
        }
        catch (ClassNotFoundException e) {
            String name = source.getInterfaceName();
            throw new ContainerException("Unable to load interface class: " + name, (Throwable)e);
        }
        if (InjectableType.CALLBACK.equals((Object)injectable.getType())) {
            throw new UnsupportedOperationException("Callbacks are not supported on system components");
        }
        String callbackUri = null;
        URI uri = target.getCallbackUri();
        if (uri != null) {
            callbackUri = uri.toString();
        }
        ObjectFactory factory = this.proxyService.createObjectFactory(type, wire, callbackUri);
        if (source.isKeyed() || source.isOrdered()) {
            Object key = this.getKey(source, target);
            int order = source.getOrder();
            InjectionAttributes attributes = new InjectionAttributes(key, order);
            component.setObjectFactory(injectable, factory, attributes);
        } else {
            component.setObjectFactory(injectable, factory);
        }
    }

    public void detach(SystemWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
        this.detachObjectFactory(source, target);
    }

    public void detachObjectFactory(SystemWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeObjectFactory(injectable);
    }

    public void attachObjectFactory(SystemWireSourceDefinition source, ObjectFactory<?> factory, PhysicalWireTargetDefinition target) throws ContainerException {
        URI sourceId = UriHelper.getDefragmentedName((URI)source.getUri());
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceId);
        Injectable injectable = source.getInjectable();
        if (source.isKeyed() || source.isOrdered()) {
            Object key = this.getKey(source, target);
            int order = source.getOrder();
            InjectionAttributes attributes = new InjectionAttributes(key, order);
            component.setObjectFactory(injectable, factory, attributes);
        } else {
            component.setObjectFactory(injectable, factory);
        }
    }
}

