/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.net.URI;
import java.util.List;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.implementation.pojo.spi.proxy.ChannelProxyService;
import org.fabric3.implementation.system.provision.SystemConnectionSourceDefinition;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SystemSourceConnectionAttacher
implements SourceConnectionAttacher<SystemConnectionSourceDefinition> {
    private ComponentManager manager;
    private ChannelProxyService proxyService;
    private ClassLoaderRegistry classLoaderRegistry;

    @Reference(required=false)
    public void setProxyService(List<ChannelProxyService> proxyServices) {
        this.proxyService = !proxyServices.isEmpty() ? proxyServices.get(0) : null;
    }

    public SystemSourceConnectionAttacher(@Reference ComponentManager manager, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.manager = manager;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(SystemConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target, ChannelConnection connection) throws ContainerException {
        Class type;
        if (this.proxyService == null) {
            throw new ContainerException("Channel proxy service not found");
        }
        URI sourceUri = source.getUri();
        URI sourceName = UriHelper.getDefragmentedName((URI)sourceUri);
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceName);
        if (component == null) {
            throw new ContainerException("Source component not found: " + sourceName);
        }
        Injectable injectable = source.getInjectable();
        try {
            type = this.classLoaderRegistry.loadClass(source.getClassLoaderId(), source.getInterfaceName());
        }
        catch (ClassNotFoundException e) {
            String name = source.getInterfaceName();
            throw new ContainerException("Unable to load interface class: " + name, (Throwable)e);
        }
        ObjectFactory factory = this.proxyService.createObjectFactory(type, connection);
        component.setObjectFactory(injectable, factory);
    }

    public void detach(SystemConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target) throws ContainerException {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeObjectFactory(injectable);
    }
}

