/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.implementation.pojo.builder.PojoComponentBuilder;
import org.fabric3.implementation.pojo.builder.PropertyObjectFactoryBuilder;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactory;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactoryBuilder;
import org.fabric3.implementation.pojo.provision.ImplementationManagerDefinition;
import org.fabric3.implementation.system.provision.SystemComponentDefinition;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.management.ManagementService;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SystemComponentBuilder
extends PojoComponentBuilder<SystemComponentDefinition, SystemComponent> {
    private ScopeRegistry scopeRegistry;
    private ImplementationManagerFactoryBuilder factoryBuilder;

    public SystemComponentBuilder(@Reference ScopeRegistry scopeRegistry, @Reference ImplementationManagerFactoryBuilder factoryBuilder, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference PropertyObjectFactoryBuilder propertyBuilder, @Reference ManagementService managementService, @Reference IntrospectionHelper helper, @Reference HostInfo info) {
        super(classLoaderRegistry, propertyBuilder, managementService, helper, info);
        this.scopeRegistry = scopeRegistry;
        this.factoryBuilder = factoryBuilder;
    }

    public SystemComponent build(SystemComponentDefinition definition) throws ContainerException {
        URI uri = definition.getComponentUri();
        QName deployable = definition.getDeployable();
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(definition.getClassLoaderId());
        ScopeContainer scopeContainer = this.scopeRegistry.getScopeContainer(Scope.COMPOSITE);
        ImplementationManagerDefinition managerDefinition = definition.getFactoryDefinition();
        ImplementationManagerFactory factory = this.factoryBuilder.build(managerDefinition, classLoader);
        this.createPropertyFactories(definition, factory);
        boolean eager = definition.isEagerInit();
        SystemComponent component = new SystemComponent(uri, factory, scopeContainer, deployable, eager);
        this.export(definition, classLoader, (AtomicComponent)component);
        return component;
    }

    public void dispose(SystemComponentDefinition definition, SystemComponent component) throws ContainerException {
        this.dispose(definition);
    }
}

