/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Property;
import org.fabric3.api.model.type.component.ReferenceDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.MultiplicityType;
import org.fabric3.spi.introspection.java.UnknownInjectionType;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.Reference;

public class SystemUnannotatedHeuristic
implements HeuristicProcessor {
    private final IntrospectionHelper helper;
    private final JavaContractProcessor contractProcessor;

    public SystemUnannotatedHeuristic(@Reference IntrospectionHelper helper, @Reference JavaContractProcessor contractProcessor) {
        this.helper = helper;
        this.contractProcessor = contractProcessor;
    }

    public void applyHeuristics(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        if (!(componentType.getProperties().isEmpty() && componentType.getReferences().isEmpty() && componentType.getResourceReferences().isEmpty())) {
            return;
        }
        this.evaluateConstructor(componentType, implClass, context);
        this.evaluateSetters(componentType, implClass, context);
        this.evaluateFields(componentType, implClass, context);
    }

    void evaluateConstructor(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        Constructor constructor;
        Map sites = componentType.getInjectionSites();
        try {
            constructor = componentType.getConstructor().getConstructor(implClass);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Type[] parameterTypes = constructor.getGenericParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, i);
            if (sites.containsKey(site)) continue;
            Type parameterType = parameterTypes[i];
            String name = this.helper.getSiteName(constructor, i, null);
            this.processSite(componentType, typeMapping, name, constructor, parameterType, (InjectionSite)site, context);
        }
    }

    void evaluateSetters(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        Map sites = componentType.getInjectionSites();
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Set setters = this.helper.getInjectionMethods(implClass, componentType.getServices().values());
        for (Method setter : setters) {
            MethodInjectionSite site = new MethodInjectionSite(setter, 0);
            if (sites.containsKey(site)) continue;
            String name = this.helper.getSiteName(setter, null);
            Type parameterType = setter.getGenericParameterTypes()[0];
            this.processSite(componentType, typeMapping, name, setter, parameterType, (InjectionSite)site, context);
        }
    }

    void evaluateFields(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        Map sites = componentType.getInjectionSites();
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Set fields = this.helper.getInjectionFields(implClass);
        for (Field field : fields) {
            FieldInjectionSite site = new FieldInjectionSite(field);
            if (sites.containsKey(site)) continue;
            String name = this.helper.getSiteName(field, null);
            Type parameterType = field.getGenericType();
            this.processSite(componentType, typeMapping, name, field, parameterType, (InjectionSite)site, context);
        }
    }

    private void processSite(InjectingComponentType componentType, TypeMapping typeMapping, String name, Member member, Type parameterType, InjectionSite site, IntrospectionContext context) {
        InjectableType type = this.helper.inferType(parameterType, typeMapping);
        switch (type) {
            case PROPERTY: {
                this.addProperty(componentType, typeMapping, name, parameterType, site);
                break;
            }
            case REFERENCE: {
                this.addReference(componentType, typeMapping, name, parameterType, site, context);
                break;
            }
            default: {
                String clazz = componentType.getImplClass();
                UnknownInjectionType error = new UnknownInjectionType(site, type, clazz, member, (ComponentType)componentType);
                context.addError((ValidationFailure)error);
            }
        }
    }

    private void addProperty(InjectingComponentType componentType, TypeMapping typeMapping, String name, Type type, InjectionSite site) {
        Property property = new Property(name);
        MultiplicityType multiplicityType = this.helper.introspectMultiplicity(type, typeMapping);
        property.setMany(MultiplicityType.COLLECTION == multiplicityType || MultiplicityType.DICTIONARY == multiplicityType);
        componentType.add(property, site);
    }

    private void addReference(InjectingComponentType componentType, TypeMapping typeMapping, String name, Type parameterType, InjectionSite site, IntrospectionContext context) {
        Class type = this.helper.getBaseType(parameterType, typeMapping);
        JavaServiceContract contract = this.contractProcessor.introspect(type, context, new ModelObject[]{componentType});
        ReferenceDefinition reference = new ReferenceDefinition(name, (ServiceContract)contract);
        this.helper.processMultiplicity(reference, false, parameterType, typeMapping);
        componentType.add(reference, site);
    }
}

