/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.introspection;

import java.util.Set;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ServiceDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Reference;

public class SystemServiceHeuristic
implements HeuristicProcessor {
    private final JavaContractProcessor contractProcessor;
    private final IntrospectionHelper helper;

    public SystemServiceHeuristic(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        this.contractProcessor = contractProcessor;
        this.helper = helper;
    }

    public void applyHeuristics(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        if (componentType.getServices().isEmpty()) {
            Set interfaces = this.helper.getImplementedInterfaces(implClass);
            if (interfaces.isEmpty()) {
                ServiceDefinition serviceDefinition = this.createServiceDefinition(implClass, componentType, context);
                componentType.add(serviceDefinition);
            } else {
                for (Class serviceInterface : interfaces) {
                    ServiceDefinition serviceDefinition = this.createServiceDefinition(serviceInterface, componentType, context);
                    componentType.add(serviceDefinition);
                }
            }
        }
    }

    private ServiceDefinition createServiceDefinition(Class<?> serviceInterface, InjectingComponentType componentType, IntrospectionContext context) {
        JavaServiceContract contract = this.contractProcessor.introspect(serviceInterface, context, new ModelObject[]{componentType});
        return new ServiceDefinition(contract.getInterfaceName(), (ServiceContract)contract);
    }
}

