/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.introspection;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.ImplementationIntrospector;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.model.type.system.SystemImplementation;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SystemImplementationLoader
extends AbstractValidatingTypeLoader<SystemImplementation> {
    private ImplementationIntrospector implementationIntrospector;

    public SystemImplementationLoader(@Reference ImplementationIntrospector implementationIntrospector) {
        this.implementationIntrospector = implementationIntrospector;
        this.addAttributes(new String[]{"class"});
    }

    public SystemImplementation load(XMLStreamReader reader, IntrospectionContext introspectionContext) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        SystemImplementation implementation = new SystemImplementation();
        this.validateAttributes(reader, introspectionContext, new ModelObject[]{implementation});
        String implClass = reader.getAttributeValue(null, "class");
        if (implClass == null) {
            MissingAttribute failure = new MissingAttribute("Implementation class must be specified using the class attribute", startLocation, new ModelObject[0]);
            introspectionContext.addError((ValidationFailure)failure);
            return null;
        }
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        implementation.setImplementationClass(implClass);
        InjectingComponentType componentType = new InjectingComponentType(implClass);
        this.implementationIntrospector.introspect(componentType, introspectionContext);
        implementation.setComponentType((ComponentType)componentType);
        return implementation;
    }
}

