/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.introspection;

import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.spi.introspection.ImplementationNotFoundException;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.ImplementationIntrospector;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.InvalidImplementation;
import org.fabric3.spi.introspection.java.MissingResource;
import org.fabric3.spi.introspection.java.annotation.ClassVisitor;
import org.oasisopen.sca.annotation.Reference;

public class SystemImplementationIntrospectorImpl
implements ImplementationIntrospector {
    private final ClassVisitor classVisitor;
    private final HeuristicProcessor heuristic;
    private final IntrospectionHelper helper;

    public SystemImplementationIntrospectorImpl(@Reference(name="classVisitor") ClassVisitor classVisitor, @Reference(name="heuristic") HeuristicProcessor heuristic, @Reference(name="helper") IntrospectionHelper helper) {
        this.classVisitor = classVisitor;
        this.heuristic = heuristic;
        this.helper = helper;
    }

    public void introspect(InjectingComponentType componentType, IntrospectionContext context) {
        Class implClass;
        String className = componentType.getImplClass();
        componentType.setScope("COMPOSITE");
        ClassLoader cl = context.getClassLoader();
        try {
            implClass = this.helper.loadClass(className, cl);
        }
        catch (ImplementationNotFoundException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException || cause instanceof NoClassDefFoundError) {
                String message = e.getCause().getMessage();
                context.addError((ValidationFailure)new MissingResource("Class referenced from system implementation not found on classpath", message, new ModelObject[]{componentType}));
            } else {
                context.addError((ValidationFailure)new MissingResource("System implementation class not found on classpath", className, new ModelObject[]{componentType}));
            }
            return;
        }
        if (implClass.isInterface()) {
            InvalidImplementation failure = new InvalidImplementation("Implementation class is an interface", implClass, componentType);
            context.addError((ValidationFailure)failure);
            return;
        }
        TypeMapping mapping = context.getTypeMapping(implClass);
        if (mapping == null) {
            mapping = new TypeMapping();
            context.addTypeMapping(implClass, mapping);
            this.helper.resolveTypeParameters(implClass, mapping);
        }
        this.classVisitor.visit(componentType, implClass, context);
        this.heuristic.applyHeuristics(componentType, implClass, context);
    }
}

