/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.introspection;

import java.lang.reflect.Constructor;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.Signature;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.NoConstructorFound;
import org.fabric3.spi.introspection.java.annotation.AmbiguousConstructor;

public class SystemConstructorHeuristic
implements HeuristicProcessor {
    public void applyHeuristics(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        if (componentType.getConstructor() != null) {
            return;
        }
        Signature signature = this.findConstructor(implClass, componentType, context);
        componentType.setConstructor(signature);
    }

    Signature findConstructor(Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        Constructor<?>[] constructors = implClass.getDeclaredConstructors();
        Constructor<?> selected = null;
        if (constructors.length == 1) {
            selected = constructors[0];
        } else {
            for (Constructor<?> constructor : constructors) {
                if (!constructor.isAnnotationPresent(org.oasisopen.sca.annotation.Constructor.class)) continue;
                if (selected != null) {
                    context.addError((ValidationFailure)new AmbiguousConstructor(implClass, componentType));
                    return null;
                }
                selected = constructor;
            }
            if (selected == null) {
                try {
                    selected = implClass.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    context.addError((ValidationFailure)new NoConstructorFound(implClass, componentType));
                    return null;
                }
            }
        }
        return new Signature(selected);
    }
}

