/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.contribution.InstallException;
import org.fabric3.contribution.processor.XmlProcessorTypeNotFoundException;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.xml.XmlProcessor;
import org.fabric3.spi.contribution.xml.XmlProcessorRegistry;
import org.fabric3.spi.introspection.IntrospectionContext;

public class XmlProcessorRegistryImpl
implements XmlProcessorRegistry {
    private Map<QName, XmlProcessor> cache = new HashMap<QName, XmlProcessor>();

    public void register(XmlProcessor processor) {
        this.cache.put(processor.getType(), processor);
    }

    public void unregister(QName name) {
        this.cache.remove(name);
    }

    public void process(Contribution contribution, XMLStreamReader reader, IntrospectionContext context) throws InstallException {
        QName name = reader.getName();
        XmlProcessor processor = this.cache.get(name);
        if (processor == null) {
            String id = name.toString();
            throw new XmlProcessorTypeNotFoundException("XML processor not found for: " + id);
        }
        processor.processContent(contribution, reader, context);
    }
}

