/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.spi.contribution.archive.ClasspathProcessor;
import org.fabric3.spi.contribution.archive.ClasspathProcessorRegistry;
import org.fabric3.spi.model.os.Library;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SymLinkClasspathProcessor
implements ClasspathProcessor {
    private final ClasspathProcessorRegistry registry;

    public SymLinkClasspathProcessor(@Reference ClasspathProcessorRegistry registry) {
        this.registry = registry;
    }

    @Init
    public void init() {
        this.registry.register((ClasspathProcessor)this);
    }

    @Destroy
    public void destroy() {
        this.registry.unregister((ClasspathProcessor)this);
    }

    public boolean canProcess(URL url) {
        return url.toString().endsWith(".contribution");
    }

    public List<URL> process(URL url, List<Library> libraries) throws IOException {
        File webInfClasses;
        File webInfLib;
        ArrayList<URL> classpath = new ArrayList<URL>();
        File root = this.deReferenceFile(url);
        classpath.add(root.toURI().toURL());
        File metaInfLib = new File(root, "META-INF" + File.separator + "lib");
        if (metaInfLib.exists()) {
            classpath.add(metaInfLib.toURI().toURL());
        }
        if ((webInfLib = new File(root, "WEB-INF" + File.separator + "lib")).exists()) {
            classpath.add(webInfLib.toURI().toURL());
        }
        if ((webInfClasses = new File(root, "WEB-INF" + File.separator + "classes")).exists()) {
            classpath.add(webInfClasses.toURI().toURL());
        }
        return classpath;
    }

    private File deReferenceFile(URL url) throws IOException {
        InputStreamReader streamReader = new InputStreamReader(url.openStream());
        BufferedReader bufferedReader = new BufferedReader(streamReader);
        String line = bufferedReader.readLine().trim();
        return new File(line);
    }
}

