/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.model.Environment;
import org.fabric3.api.annotation.model.Provides;
import org.fabric3.api.host.contribution.InstallException;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.component.Autowire;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.contribution.processor.DuplicateProviderComposite;
import org.fabric3.contribution.processor.InvalidProviderMethod;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.ProviderSymbol;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceProcessor;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.domain.LogicalComponentManager;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.ImplementationIntrospector;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ProviderResourceProcessor
implements ResourceProcessor {
    private HostInfo info;
    private Map<QName, ImplementationIntrospector> introspectors = Collections.emptyMap();
    private Autowire domainAutowire;

    public ProviderResourceProcessor(@Reference ProcessorRegistry processorRegistry, @Reference LogicalComponentManager lcm, @Reference HostInfo info) {
        this.info = info;
        this.domainAutowire = lcm.getRootComponent().getAutowire();
        processorRegistry.register((ResourceProcessor)this);
    }

    @Reference(required=false)
    public void setIntrospectors(Map<QName, ImplementationIntrospector> processors) {
        this.introspectors = processors;
    }

    public String getContentType() {
        return "text/vnd.fabric3.dsl";
    }

    public void index(Resource resource, IntrospectionContext context) throws InstallException {
        Class<?> provider;
        ResourceElement element = (ResourceElement)resource.getResourceElements().get(0);
        ProviderSymbol symbol = (ProviderSymbol)element.getSymbol();
        String className = (String)symbol.getKey();
        try {
            provider = context.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            InvalidProviderMethod error = new InvalidProviderMethod("Error loading provider class: " + className, e);
            context.addError((ValidationFailure)error);
            return;
        }
        for (Method method : provider.getDeclaredMethods()) {
            InvalidProviderMethod error;
            try {
                if (!method.isAnnotationPresent(Provides.class)) continue;
                if (!Composite.class.equals(method.getReturnType())) {
                    InvalidProviderMethod error2 = new InvalidProviderMethod("Provides must return type " + Composite.class.getName() + ": " + method);
                    context.addError((ValidationFailure)error2);
                    continue;
                }
                String environmentArg = null;
                if (method.getParameterTypes().length > 0) {
                    if (method.getParameterTypes().length == 1) {
                        if (method.getParameterAnnotations()[0].length != 1 || !(method.getParameterAnnotations()[0][0] instanceof Environment)) {
                            error = new InvalidProviderMethod("Unknown provider parameter type: " + method);
                            context.addError((ValidationFailure)error);
                            continue;
                        }
                        if (!method.getParameterTypes()[0].equals(String.class)) {
                            error = new InvalidProviderMethod("Unknown provider parameter type: " + method);
                            context.addError((ValidationFailure)error);
                            continue;
                        }
                        environmentArg = this.info.getEnvironment();
                    } else {
                        error = new InvalidProviderMethod("Provides method cannot take more than one parameter: " + method);
                        context.addError((ValidationFailure)error);
                        continue;
                    }
                }
                if (!Modifier.isStatic(method.getModifiers())) {
                    error = new InvalidProviderMethod("Provides method must be static: " + method);
                    context.addError((ValidationFailure)error);
                    continue;
                }
                Composite composite = environmentArg == null ? (Composite)method.invoke(null, new Object[0]) : (Composite)method.invoke(null, environmentArg);
                if (composite == null) continue;
                if (composite.getAutowire() == null) {
                    composite.setAutowire(this.domainAutowire);
                }
                URI contributionUri = context.getContributionUri();
                composite.setContributionUri(contributionUri);
                for (ComponentDefinition definition : composite.getComponents().values()) {
                    ImplementationIntrospector introspector = this.introspectors.get(definition.getImplementation().getType());
                    if (introspector == null) continue;
                    definition.setContributionUri(contributionUri);
                    introspector.introspect((InjectingComponentType)definition.getComponentType(), context);
                }
                QName compositeName = composite.getName();
                QNameSymbol compositeSymbol = new QNameSymbol(compositeName);
                ResourceElement compositeElement = new ResourceElement((Symbol)compositeSymbol, (Object)composite);
                Contribution contribution = resource.getContribution();
                Resource compositeResource = new Resource(contribution, resource.getSource(), "text/vnd.fabric3.composite+xml");
                compositeResource.addResourceElement(compositeElement);
                this.validateUnique(compositeResource, (ResourceElement<QNameSymbol, Composite>)compositeElement, method, context);
                compositeResource.setState(ResourceState.PROCESSED);
                contribution.addResource(compositeResource);
            }
            catch (InvocationTargetException e) {
                error = new InvalidProviderMethod("Error invoking provides method: " + method, e.getTargetException());
                context.addError((ValidationFailure)error);
            }
            catch (IllegalAccessException e) {
                error = new InvalidProviderMethod("Error invoking provides method: " + method, e);
                context.addError((ValidationFailure)error);
            }
        }
        resource.setState(ResourceState.PROCESSED);
    }

    public void process(Resource resource, IntrospectionContext context) throws InstallException {
    }

    private void validateUnique(Resource resource, ResourceElement<QNameSymbol, Composite> element, Method method, IntrospectionContext context) {
        Contribution contribution = resource.getContribution();
        block0: for (Resource entry : contribution.getResources()) {
            if (resource == entry || !resource.getContentType().equals(entry.getContentType())) continue;
            for (ResourceElement elementEntry : entry.getResourceElements()) {
                if (!((QNameSymbol)element.getSymbol()).equals((Object)elementEntry.getSymbol())) continue;
                QName name = (QName)((QNameSymbol)element.getSymbol()).getKey();
                DuplicateProviderComposite error = new DuplicateProviderComposite("Duplicate composite found with name: " + name + ":" + method);
                context.addError((ValidationFailure)error);
                continue block0;
            }
        }
    }
}

