/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.model.Component;
import org.fabric3.api.host.contribution.Deployable;
import org.fabric3.api.host.contribution.InstallException;
import org.fabric3.api.host.contribution.StoreException;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.host.stream.Source;
import org.fabric3.api.model.type.component.Autowire;
import org.fabric3.api.model.type.component.ComponentDefinition;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Include;
import org.fabric3.contribution.processor.InvalidComponentAnnotation;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.JavaResourceProcessorExtension;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceProcessor;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.ComponentProcessor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JavaResourceProcessor
implements ResourceProcessor {
    private ComponentProcessor componentProcessor;
    private MetaDataStore store;
    private List<JavaResourceProcessorExtension> processorExtensions = Collections.emptyList();

    public JavaResourceProcessor(@Reference ProcessorRegistry registry, @Reference ComponentProcessor componentProcessor, @Reference MetaDataStore store) {
        this.componentProcessor = componentProcessor;
        this.store = store;
        registry.register((ResourceProcessor)this);
    }

    @Reference(required=false)
    public void setProcessorExtensions(List<JavaResourceProcessorExtension> processorExtensions) {
        this.processorExtensions = processorExtensions;
    }

    public String getContentType() {
        return "text/vnd.fabric3.component+java";
    }

    public void index(Resource resource, IntrospectionContext context) throws InstallException {
        ResourceElement resourceElement = (ResourceElement)resource.getResourceElements().get(0);
        Class clazz = (Class)resourceElement.getValue();
        Component annotation = clazz.getAnnotation(Component.class);
        String name = clazz.getSimpleName();
        if (annotation != null && annotation.name().length() > 0) {
            name = annotation.name();
        }
        try {
            QName compositeName = this.getCompositeName(resourceElement, annotation);
            ComponentDefinition definition = new ComponentDefinition(name);
            definition.setContributionUri(context.getContributionUri());
            this.componentProcessor.process(definition, clazz, context);
            ParsedComponentSymbol symbol = new ParsedComponentSymbol(definition);
            ResourceElement parsedElement = new ResourceElement((Symbol)symbol, (Object)compositeName);
            resource.addResourceElement(parsedElement);
        }
        catch (IllegalArgumentException e) {
            InvalidComponentAnnotation error = new InvalidComponentAnnotation("Invalid composite name: " + name + " on class: " + clazz.getName(), e);
            context.addError((ValidationFailure)error);
        }
    }

    private QName getCompositeName(ResourceElement<?, ?> resourceElement, Component annotation) {
        QName compositeName;
        if (annotation != null) {
            compositeName = QName.valueOf(annotation.composite());
        } else {
            compositeName = (QName)resourceElement.getMetadata(QName.class);
            if (compositeName == null) {
                compositeName = QName.valueOf("{urn:fabric3.org}DefaultApplicationComposite");
            }
        }
        return compositeName;
    }

    public void process(Resource resource, IntrospectionContext context) throws InstallException {
        ResourceElement resourceElement = null;
        for (ResourceElement element : resource.getResourceElements()) {
            if (!(element.getSymbol() instanceof ParsedComponentSymbol)) continue;
            resourceElement = element;
            break;
        }
        ComponentDefinition definition = (ComponentDefinition)((ParsedComponentSymbol)resourceElement.getSymbol()).getKey();
        QName compositeName = (QName)resourceElement.getValue();
        QNameSymbol compositeSymbol = new QNameSymbol(compositeName);
        Contribution contribution = resource.getContribution();
        Composite composite = null;
        try {
            ResourceElement element = this.store.resolve(context.getContributionUri(), Composite.class, (Symbol)compositeSymbol, context);
            if (element != null) {
                composite = (Composite)element.getValue();
            }
        }
        catch (StoreException e) {
            throw new InstallException((Throwable)e);
        }
        if (composite == null) {
            composite = new Composite(compositeName);
            composite.setAutowire(Autowire.INHERITED);
            composite.setContributionUri(contribution.getUri());
            composite.setDeployable(true);
            NullSource source = new NullSource(compositeName.toString());
            Resource compositeResource = new Resource(contribution, (Source)source, "text/vnd.fabric3.composite+xml");
            compositeResource.setState(ResourceState.PROCESSED);
            compositeResource.addResourceElement(new ResourceElement((Symbol)compositeSymbol, (Object)composite));
            resource.setContribution(contribution);
            contribution.addResource(compositeResource);
            ContributionManifest manifest = contribution.getManifest();
            if (manifest.getDeployables().isEmpty()) {
                Deployable deployable = new Deployable(compositeName);
                manifest.addDeployable(deployable);
            }
            composite.add(definition);
        } else {
            if (definition.getAutowire() == Autowire.INHERITED) {
                definition.setAutowire(composite.getAutowire());
            } else if (definition.getAutowire() == null) {
                definition.setAutowire(Autowire.INHERITED);
            }
            composite.add(definition);
            this.updateIncludingComposites(contribution, composite);
        }
        for (JavaResourceProcessorExtension extension : this.processorExtensions) {
            extension.process(definition);
        }
        resource.setState(ResourceState.PROCESSED);
    }

    private void updateIncludingComposites(Contribution contribution, Composite composite) {
        for (Resource contributionResource : contribution.getResources()) {
            block1: for (ResourceElement element : contributionResource.getResourceElements()) {
                if (!(element.getValue() instanceof Composite)) continue;
                Composite candidate = (Composite)element.getValue();
                for (Include include : candidate.getIncludes().values()) {
                    if (!include.getIncluded().getName().equals(composite.getName())) continue;
                    candidate.add(include);
                    continue block1;
                }
            }
        }
    }

    private class NullSource
    implements Source {
        private String name;

        private NullSource(String name) {
            this.name = name;
        }

        public String getSystemId() {
            return this.name;
        }

        public URL getBaseLocation() {
            return null;
        }

        public InputStream openStream() throws IOException {
            return null;
        }

        public Source getImportSource(String parentLocation, String importLocation) throws IOException {
            return null;
        }
    }

    private class ParsedComponentSymbol
    extends Symbol<ComponentDefinition> {
        public ParsedComponentSymbol(ComponentDefinition definition) {
            super((Object)definition);
        }
    }
}

