/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.manifest;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.contribution.manifest.ContributionExport;
import org.fabric3.contribution.manifest.MissingManifestAttribute;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class ContributionExportLoader
extends AbstractValidatingTypeLoader<ContributionExport> {
    private URI INVALID_URI = URI.create("invalid");

    public ContributionExportLoader() {
        this.addAttributes(new String[]{"uri"});
    }

    public ContributionExport load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        this.validateAttributes(reader, context, new ModelObject[0]);
        String uriStr = reader.getAttributeValue(null, "uri");
        if (uriStr == null) {
            MissingManifestAttribute failure = new MissingManifestAttribute("The uri attribute must be specified", startLocation);
            context.addError((ValidationFailure)failure);
            return null;
        }
        try {
            URI uri = new URI(uriStr);
            return new ContributionExport(uri);
        }
        catch (URISyntaxException e) {
            InvalidValue error = new InvalidValue("Invalid symbolicUri attribute", startLocation, (Throwable)e, new ModelObject[0]);
            context.addError((ValidationFailure)error);
            return new ContributionExport(this.INVALID_URI);
        }
    }
}

