/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.io.File;
import java.net.URL;
import org.fabric3.api.host.contribution.InstallException;
import org.fabric3.api.host.util.FileHelper;
import org.fabric3.contribution.archive.AbstractContributionProcessor;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class SyntheticDirectoryContributionProcessor
extends AbstractContributionProcessor {
    private static final String CONTENT_TYPE = "application/vnd.fabric3.synthetic";

    public boolean canProcess(Contribution contribution) {
        return CONTENT_TYPE.equals(contribution.getContentType());
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) throws InstallException {
        URL sourceUrl = contribution.getLocation();
        File root = FileHelper.toFile((URL)sourceUrl);
        assert (root.isDirectory());
        ContributionManifest manifest = contribution.getManifest();
        manifest.setExtension(true);
        manifest.addExtend(root.getName());
    }

    public void index(Contribution contribution, IntrospectionContext context) throws InstallException {
    }

    public void process(Contribution contribution, IntrospectionContext context) throws InstallException {
    }
}

