/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.fabric3.api.host.contribution.InstallException;
import org.fabric3.api.host.stream.Source;
import org.fabric3.api.host.stream.UrlSource;
import org.fabric3.api.host.util.FileHelper;
import org.fabric3.spi.contribution.ContentTypeResolutionException;
import org.fabric3.spi.contribution.ContentTypeResolver;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.JavaArtifactIntrospector;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.archive.ArchiveContributionHandler;
import org.fabric3.spi.contribution.archive.ArtifactResourceCallback;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.Loader;
import org.fabric3.spi.introspection.xml.LoaderException;
import org.oasisopen.sca.annotation.Reference;

public class ExplodedArchiveContributionHandler
implements ArchiveContributionHandler {
    private Loader loader;
    private List<JavaArtifactIntrospector> artifactIntrospectors = Collections.emptyList();
    private final ContentTypeResolver contentTypeResolver;

    public ExplodedArchiveContributionHandler(@Reference Loader loader, @Reference ContentTypeResolver contentTypeResolver) {
        this.loader = loader;
        this.contentTypeResolver = contentTypeResolver;
    }

    @Reference
    public void setArtifactIntrospectors(List<JavaArtifactIntrospector> introspectors) {
        this.artifactIntrospectors = introspectors;
    }

    public boolean canProcess(Contribution contribution) {
        URL location = contribution.getLocation();
        if (location == null || !"file".equals(location.getProtocol())) {
            return false;
        }
        File file = new File(location.getFile());
        String contentType = contribution.getContentType();
        return file.isDirectory() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip") || "text/vnd.fabric3.exploded".equals(contentType));
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) throws InstallException {
        try {
            String sourceUrl = contribution.getLocation().toString();
            URL manifestUrl = new URL(sourceUrl + "/META-INF/sca-contribution.xml");
            File file = new File(manifestUrl.getPath());
            if (!file.exists()) {
                manifestUrl = new URL(sourceUrl + "/WEB-INF/sca-contribution.xml");
            }
            ClassLoader cl = this.getClass().getClassLoader();
            URI uri = contribution.getUri();
            DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(uri, cl);
            UrlSource source = new UrlSource(manifestUrl);
            ContributionManifest manifest = (ContributionManifest)this.loader.load((Source)source, ContributionManifest.class, (IntrospectionContext)childContext);
            if (childContext.hasErrors()) {
                context.addErrors(childContext.getErrors());
            }
            if (childContext.hasWarnings()) {
                context.addWarnings(childContext.getWarnings());
            }
            contribution.setManifest(manifest);
        }
        catch (LoaderException e) {
            if (!(e.getCause() instanceof FileNotFoundException)) {
                throw new InstallException((Throwable)e);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
    }

    public void iterateArtifacts(Contribution contribution, ArtifactResourceCallback callback, IntrospectionContext context) throws InstallException {
        File root = FileHelper.toFile((URL)contribution.getLocation());
        this.iterateArtifactsRecursive(root, root, contribution, callback, context);
    }

    protected void iterateArtifactsRecursive(File dir, File root, Contribution contribution, ArtifactResourceCallback callback, IntrospectionContext context) throws InstallException {
        File[] files = dir.listFiles();
        ContributionManifest manifest = contribution.getManifest();
        for (File file : files) {
            if (file.isDirectory()) {
                this.iterateArtifactsRecursive(file, root, contribution, callback, context);
                continue;
            }
            try {
                URL entryUrl;
                String name = file.getName();
                if (name.equals("sca-contribution.xml") || this.exclude(file, root, manifest)) continue;
                boolean isClass = file.getName().endsWith(".class");
                if (isClass) {
                    name = this.getRelativeName(file, root).replace(File.separator, ".").substring(0, file.getName().length() - 6);
                    try {
                        JavaArtifactIntrospector introspector;
                        Class<?> clazz = context.getClassLoader().loadClass(name);
                        entryUrl = file.toURI().toURL();
                        Resource resource = null;
                        Iterator<JavaArtifactIntrospector> i$ = this.artifactIntrospectors.iterator();
                        while (i$.hasNext() && (resource = (introspector = i$.next()).inspect(clazz, entryUrl, contribution, context)) == null) {
                        }
                        if (resource == null) continue;
                        contribution.addResource(resource);
                        callback.onResource(resource);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {}
                    continue;
                }
                String contentType = this.contentTypeResolver.getContentType(name);
                if (contentType == null) continue;
                entryUrl = file.toURI().toURL();
                UrlSource source = new UrlSource(entryUrl);
                Resource resource = new Resource(contribution, (Source)source, contentType);
                contribution.addResource(resource);
                callback.onResource(resource);
            }
            catch (MalformedURLException | ContentTypeResolutionException e) {
                throw new InstallException(e);
            }
        }
    }

    private boolean exclude(File file, File root, ContributionManifest manifest) {
        String relativeName = this.getRelativeName(file, root);
        for (Pattern pattern : manifest.getScanExcludes()) {
            if (!pattern.matcher(relativeName).matches()) continue;
            return true;
        }
        return false;
    }

    private String getRelativeName(File file, File root) {
        return file.toURI().toString().substring(root.toURI().toString().length());
    }
}

