/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.lang.reflect.Modifier;
import java.net.URL;
import org.fabric3.api.annotation.model.Component;
import org.fabric3.api.host.stream.Source;
import org.fabric3.api.host.stream.UrlSource;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.JavaArtifactIntrospector;
import org.fabric3.spi.contribution.JavaSymbol;
import org.fabric3.spi.contribution.ProviderSymbol;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.introspection.IntrospectionContext;

public class ComponentJavaArtifactIntrospector
implements JavaArtifactIntrospector {
    public Resource inspect(Class<?> clazz, URL url, Contribution contribution, IntrospectionContext context) {
        String name = clazz.getName();
        if (this.isProvider(name)) {
            UrlSource source = new UrlSource(url);
            Resource resource = new Resource(contribution, (Source)source, "text/vnd.fabric3.dsl");
            ProviderSymbol symbol = new ProviderSymbol(name);
            ResourceElement element = new ResourceElement((Symbol)symbol);
            resource.addResourceElement(element);
            return resource;
        }
        if (!contribution.getManifest().isExtension() && clazz.isAnnotationPresent(Component.class) && !Modifier.isAbstract(clazz.getModifiers())) {
            UrlSource source = new UrlSource(url);
            Resource resource = new Resource(contribution, (Source)source, "text/vnd.fabric3.component+java");
            JavaSymbol symbol = new JavaSymbol(name);
            ResourceElement resourceElement = new ResourceElement((Symbol)symbol, clazz);
            resource.addResourceElement(resourceElement);
            return resource;
        }
        return null;
    }

    private boolean isProvider(String name) {
        return name.startsWith("f3.") && name.endsWith("Provider");
    }
}

