/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.host.contribution.InstallException;
import org.fabric3.api.host.contribution.UnsupportedContentTypeException;
import org.fabric3.contribution.archive.AbstractContributionProcessor;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.archive.ArchiveContributionHandler;
import org.fabric3.spi.contribution.archive.ArtifactResourceCallback;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.oasisopen.sca.annotation.Reference;

public class ArchiveContributionProcessor
extends AbstractContributionProcessor {
    private List<ArchiveContributionHandler> handlers;

    @Reference
    public void setHandlers(List<ArchiveContributionHandler> handlers) {
        this.handlers = handlers;
    }

    public boolean canProcess(Contribution contribution) {
        for (ArchiveContributionHandler handler : this.handlers) {
            if (!handler.canProcess(contribution)) continue;
            return true;
        }
        return false;
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) throws InstallException {
        ArchiveContributionHandler handler = this.getHandler(contribution);
        handler.processManifest(contribution, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(Contribution contribution, final IntrospectionContext context) throws InstallException {
        ArchiveContributionHandler handler = this.getHandler(contribution);
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = context.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            handler.iterateArtifacts(contribution, new ArtifactResourceCallback(){

                public void onResource(Resource resource) throws InstallException {
                    ArchiveContributionProcessor.this.registry.indexResource(resource, context);
                }
            }, context);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Contribution contribution, IntrospectionContext context) throws InstallException {
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = context.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            ArrayList copy = new ArrayList(contribution.getResources());
            for (Resource resource : copy) {
                if (ResourceState.UNPROCESSED != resource.getState()) continue;
                this.registry.processResource(resource, context);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    private ArchiveContributionHandler getHandler(Contribution contribution) throws UnsupportedContentTypeException {
        for (ArchiveContributionHandler handler : this.handlers) {
            if (!handler.canProcess(contribution)) continue;
            return handler;
        }
        String source = contribution.getUri().toString();
        throw new UnsupportedContentTypeException("Contribution type not supported: " + source);
    }
}

