/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.api.host.contribution.InstallException;
import org.fabric3.api.host.contribution.UnsupportedContentTypeException;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionProcessor;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceProcessor;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class ProcessorRegistryImpl
implements ProcessorRegistry {
    private List<ContributionProcessor> contributionProcessorCache = new ArrayList<ContributionProcessor>();
    private Map<String, ResourceProcessor> resourceProcessorCache = new ConcurrentHashMap<String, ResourceProcessor>();

    public void register(ContributionProcessor processor) {
        this.contributionProcessorCache.add(processor);
    }

    public void unregister(ContributionProcessor processor) {
        this.contributionProcessorCache.remove(processor);
    }

    public void register(ResourceProcessor processor) {
        this.resourceProcessorCache.put(processor.getContentType(), processor);
    }

    public void unregister(String contentType) {
        this.resourceProcessorCache.remove(contentType);
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) throws InstallException {
        ContributionProcessor processor = this.getContributionProcessor(contribution);
        processor.processManifest(contribution, context);
    }

    public void indexContribution(Contribution contribution, IntrospectionContext context) throws InstallException {
        ContributionProcessor processor = this.getContributionProcessor(contribution);
        processor.index(contribution, context);
    }

    public void indexResource(Resource resource, IntrospectionContext context) throws InstallException {
        String contentType = resource.getContentType();
        ResourceProcessor processor = this.resourceProcessorCache.get(contentType);
        if (processor == null) {
            return;
        }
        processor.index(resource, context);
    }

    public void processContribution(Contribution contribution, IntrospectionContext context) throws InstallException {
        ContributionProcessor processor = this.getContributionProcessor(contribution);
        processor.process(contribution, context);
    }

    public void processResource(Resource resource, IntrospectionContext context) throws InstallException {
        if (ResourceState.ERROR == resource.getState()) {
            return;
        }
        ResourceProcessor processor = this.resourceProcessorCache.get(resource.getContentType());
        if (processor == null) {
            return;
        }
        processor.process(resource, context);
    }

    public ContributionProcessor getContributionProcessor(Contribution contribution) throws UnsupportedContentTypeException {
        for (ContributionProcessor processor : this.contributionProcessorCache) {
            if (!processor.canProcess(contribution)) continue;
            return processor;
        }
        String source = contribution.getUri().toString();
        throw new UnsupportedContentTypeException("Processor not found for contribution " + source);
    }
}

