/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionResolver;
import org.fabric3.spi.contribution.ContributionResolverExtension;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ResolutionException;
import org.fabric3.spi.repository.ArtifactCache;
import org.fabric3.spi.repository.CacheException;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class DefaultContributionResolver
implements ContributionResolver {
    private MetaDataStore store;
    private ArtifactCache cache;
    private List<ContributionResolverExtension> extensions;

    @Constructor
    public DefaultContributionResolver(@Reference MetaDataStore store, @Reference ArtifactCache cache) {
        this.store = store;
        this.cache = cache;
        this.extensions = Collections.emptyList();
    }

    @Reference(required=false)
    public void setExtensions(List<ContributionResolverExtension> extensions) {
        this.extensions = extensions;
    }

    public URL resolve(URI contributionUri) throws ResolutionException {
        Contribution contribution = this.store.find(contributionUri);
        if (contribution != null) {
            return contribution.getLocation();
        }
        URL url = this.cache.get(contributionUri);
        if (url != null) {
            return url;
        }
        for (ContributionResolverExtension extension : this.extensions) {
            InputStream stream = extension.resolve(contributionUri);
            if (stream == null) continue;
            try {
                return this.cache.cache(contributionUri, stream);
            }
            catch (CacheException e) {
                throw new ResolutionException("Error resolving contribution: " + contributionUri, (Throwable)e);
            }
        }
        throw new ResolutionException("Contribution not found: " + contributionUri);
    }

    public List<URL> resolveAllLocations(URI contributionUri) throws ResolutionException {
        Contribution contribution = this.store.find(contributionUri);
        if (contribution != null) {
            ArrayList<URL> locations = new ArrayList<URL>();
            locations.add(contribution.getLocation());
            locations.addAll(contribution.getAdditionalLocations());
            return locations;
        }
        URL url = this.cache.get(contributionUri);
        if (url != null) {
            return Collections.singletonList(url);
        }
        for (ContributionResolverExtension extension : this.extensions) {
            InputStream stream = extension.resolve(contributionUri);
            if (stream == null) continue;
            try {
                return Collections.singletonList(this.cache.cache(contributionUri, stream));
            }
            catch (CacheException e) {
                throw new ResolutionException("Error resolving contribution: " + contributionUri, (Throwable)e);
            }
        }
        throw new ResolutionException("Contribution not found: " + contributionUri);
    }

    public void release(URI contributionUri) throws ResolutionException {
        try {
            this.cache.remove(contributionUri);
        }
        catch (CacheException e) {
            throw new ResolutionException("Error releasing artifact: " + contributionUri, (Throwable)e);
        }
    }
}

