/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.xml;

import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.fabric3.spi.xml.XMLFactory;
import org.fabric3.spi.xml.XMLFactoryInstantiationException;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Property;

public final class XMLFactoryImpl
implements XMLFactory {
    private final String inputFactoryName;
    private final String outputFactoryName;
    private final ClassLoader classLoader = this.getClass().getClassLoader();

    public XMLFactoryImpl() {
        this("com.ctc.wstx.stax.WstxInputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
    }

    @Constructor
    public XMLFactoryImpl(@Property(name="input") String inputFactoryName, @Property(name="output") String outputFactoryName) {
        this.inputFactoryName = inputFactoryName;
        this.outputFactoryName = outputFactoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLInputFactory newInputFactoryInstance() throws FactoryConfigurationError {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            XMLInputFactory xMLInputFactory = this.newInputFactoryInstance(this.inputFactoryName, this.classLoader);
            return xMLInputFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public XMLOutputFactory newOutputFactoryInstance() throws FactoryConfigurationError {
        return this.newOutputFactoryInstance(this.outputFactoryName, this.classLoader);
    }

    private XMLInputFactory newInputFactoryInstance(String factoryName, ClassLoader cl) throws XMLFactoryInstantiationException {
        try {
            Class<?> clazz = cl.loadClass(factoryName);
            return (XMLInputFactory)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new XMLFactoryInstantiationException("Error instantiating factory: " + factoryName, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new XMLFactoryInstantiationException("Error loading factory: " + factoryName, (Throwable)e);
        }
    }

    private XMLOutputFactory newOutputFactoryInstance(String factoryName, ClassLoader cl) throws FactoryConfigurationError {
        try {
            Class<?> clazz = cl.loadClass(factoryName);
            return (XMLOutputFactory)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new XMLFactoryInstantiationException("Error instantiating factory: " + factoryName, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new XMLFactoryInstantiationException("Error loading factory: " + factoryName, (Throwable)e);
        }
    }
}

